/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import com.onionnetworks.dime.DimeRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class DimeParser
implements Iterator {
    private Object nextStoplight = new Object();
    private InputStream in;
    private DimeRecord prev = null;

    public DimeParser(InputStream is) {
        this.in = is;
    }

    public synchronized Object next() {
        try {
            return this.nextRecord();
        }
        catch (IOException doh) {
            doh.printStackTrace();
            throw new NoSuchElementException("IOException");
        }
    }

    public synchronized DimeRecord nextRecord() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Last Message already returned");
        }
        this.prev = DimeRecord.extract(this.in);
        return this.prev;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.prev == null || !this.prev.isLast();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static List<DimeRecord> getAllRecords(DimeParser parser) throws IOException {
        LinkedList<DimeRecord> records = new LinkedList<DimeRecord>();
        while (parser.hasNext()) {
            records.add(parser.nextRecord());
        }
        return records;
    }

    public static void main(String[] args) throws Exception {
        DimeParser dp = new DimeParser(new FileInputStream(new File(args[0])));
        int nextRecord = 0;
        int nextPart = 0;
        FileOutputStream fos = null;
        while (dp.hasNext()) {
            System.out.println("-----[ Record: " + nextRecord++);
            DimeRecord dr = dp.nextRecord();
            long pl = dr.getData().length;
            System.out.println("Payload Length: " + pl);
            System.out.println("Id: " + dr.getId());
            System.out.println("Type: " + new String(dr.getType() != null ? dr.getType() : "<null>"));
            System.out.println("TNF: " + dr.getTypeNameFormat().toInt());
            System.out.println("First:" + dr.isFirst());
            System.out.println("Last:" + dr.isLast());
            if (fos == null) {
                fos = new FileOutputStream(new File("part-" + ++nextPart));
            }
            byte[] data = dr.getData();
            fos.write(data, 0, data.length);
            fos.flush();
            fos.close();
            fos = null;
            System.out.println("Payload: <part-" + nextPart + ">");
        }
    }
}

