/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

import com.bitzi.util.Tiger;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import phex.common.log.NLogger;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private static final boolean USE_CRYPTIX;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private List nodes = new ArrayList();

    public TigerTree() {
        super("tigertree");
        if (USE_CRYPTIX) {
            try {
                this.tiger = MessageDigest.getInstance("Tiger", "CryptixCrypto");
            }
            catch (NoSuchAlgorithmException nsae) {
                this.tiger = new Tiger();
            }
            catch (NoSuchProviderException nspe) {
                this.tiger = new Tiger();
            }
        } else {
            this.tiger = new Tiger();
        }
    }

    @Override
    protected int engineGetDigestLength() {
        return 24;
    }

    @Override
    protected void engineUpdate(byte in) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = in;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] in, int offset, int length) {
        int remaining;
        this.byteCount += (long)length;
        while (length >= (remaining = 1024 - this.bufferOffset)) {
            System.arraycopy(in, offset, this.buffer, this.bufferOffset, remaining);
            this.bufferOffset += remaining;
            this.blockUpdate();
            length -= remaining;
            offset += remaining;
            this.bufferOffset = 0;
        }
        System.arraycopy(in, offset, this.buffer, this.bufferOffset, length);
        this.bufferOffset += length;
    }

    @Override
    protected byte[] engineDigest() {
        byte[] hash = new byte[24];
        try {
            this.engineDigest(hash, 0, 24);
        }
        catch (DigestException e) {
            return null;
        }
        return hash;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        while (this.nodes.size() > 1) {
            ArrayList<byte[]> newNodes = new ArrayList<byte[]>();
            Iterator iter = this.nodes.iterator();
            while (iter.hasNext()) {
                byte[] left = (byte[])iter.next();
                if (iter.hasNext()) {
                    byte[] right = (byte[])iter.next();
                    this.tiger.reset();
                    this.tiger.update((byte)1);
                    this.tiger.update(left, 0, left.length);
                    this.tiger.update(right, 0, right.length);
                    newNodes.add(this.tiger.digest());
                    continue;
                }
                newNodes.add(left);
            }
            this.nodes = newNodes;
        }
        System.arraycopy(this.nodes.get(0), 0, buf, offset, 24);
        this.engineReset();
        return 24;
    }

    @Override
    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new ArrayList();
        this.tiger.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(this.buffer, 0, this.bufferOffset);
        if (this.bufferOffset == 0 & this.nodes.size() > 0) {
            return;
        }
        this.nodes.add(this.tiger.digest());
    }

    static {
        boolean bl = USE_CRYPTIX = SystemUtils.isJavaVersionAtLeast(140) && SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_VERSION.startsWith("10.2");
        if (USE_CRYPTIX) {
            try {
                Class<?> clazz = Class.forName("cryptix.jce.provider.CryptixCrypto");
                Object o = clazz.newInstance();
                Security.addProvider((Provider)o);
            }
            catch (ClassNotFoundException e) {
                NLogger.error(TigerTree.class, (Object)e, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                NLogger.error(TigerTree.class, (Object)e, (Throwable)e);
            }
            catch (InstantiationException e) {
                NLogger.error(TigerTree.class, (Object)e, (Throwable)e);
            }
            catch (ExceptionInInitializerError e) {
                NLogger.error(TigerTree.class, (Object)e, (Throwable)e);
            }
            catch (SecurityException e) {
                NLogger.error(TigerTree.class, (Object)e, (Throwable)e);
            }
            catch (ClassCastException e) {
                NLogger.error(TigerTree.class, (Object)e, (Throwable)e);
            }
        }
    }
}

