/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.util.Executor;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class SimpleTimer {
    private static final SimpleTimer _instance = new SimpleTimer();
    private I2PAppContext _context;
    private Log _log;
    private TreeMap _events;
    private Map _eventTimes;
    private List _readyEvents;
    private long _occurredTime;
    private long _occurredEventCount;
    private TimedEvent[] _recentEvents = new TimedEvent[5];
    static /* synthetic */ Class class$net$i2p$util$SimpleTimer;

    public static SimpleTimer getInstance() {
        return _instance;
    }

    protected SimpleTimer() {
        this("SimpleTimer");
    }

    protected SimpleTimer(String name) {
        this._context = I2PAppContext.getGlobalContext();
        this._log = this._context.logManager().getLog(class$net$i2p$util$SimpleTimer == null ? (class$net$i2p$util$SimpleTimer = SimpleTimer.class$("net.i2p.util.SimpleTimer")) : class$net$i2p$util$SimpleTimer);
        this._events = new TreeMap();
        this._eventTimes = new HashMap(256);
        this._readyEvents = new ArrayList(4);
        I2PThread runner = new I2PThread(new SimpleTimerRunner());
        runner.setName(name);
        runner.setDaemon(true);
        runner.start();
        for (int i = 0; i < 3; ++i) {
            I2PThread executor = new I2PThread(new Executor(this._context, this._log, this._readyEvents));
            executor.setName(name + "Executor " + i);
            executor.setDaemon(true);
            executor.start();
        }
    }

    public void reschedule(TimedEvent event, long timeoutMs) {
        this.addEvent(event, timeoutMs, false);
    }

    public void addEvent(TimedEvent event, long timeoutMs) {
        this.addEvent(event, timeoutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(TimedEvent event, long timeoutMs, boolean useEarliestTime) {
        long timeToAdd;
        int totalEvents = 0;
        long now = System.currentTimeMillis();
        long eventTime = now + timeoutMs;
        Long time = new Long(eventTime);
        TreeMap treeMap = this._events;
        synchronized (treeMap) {
            Long oldTime = (Long)this._eventTimes.get(event);
            if (oldTime != null) {
                if (useEarliestTime) {
                    if (oldTime < eventTime) {
                        this._events.notifyAll();
                        return;
                    }
                    this._events.remove(oldTime);
                } else {
                    if (oldTime > eventTime) {
                        this._events.notifyAll();
                        return;
                    }
                    this._events.remove(oldTime);
                }
            }
            while (this._events.containsKey(time)) {
                time = new Long(time + 1L);
            }
            this._events.put(time, event);
            this._eventTimes.put(event, time);
            if (this._events.size() != this._eventTimes.size()) {
                this._log.error("Skewed events: " + this._events.size() + " for " + this._eventTimes.size());
                Iterator iter = this._eventTimes.keySet().iterator();
                while (iter.hasNext()) {
                    TimedEvent evt = (TimedEvent)iter.next();
                    Long when = (Long)this._eventTimes.get(evt);
                    TimedEvent cur = (TimedEvent)this._events.get(when);
                    if (cur == evt) continue;
                    this._log.error("event " + evt + " @ " + when + ": " + cur);
                }
            }
            totalEvents = this._events.size();
            this._events.notifyAll();
        }
        if (time > eventTime + 100L && this._log.shouldLog(40)) {
            this._log.error("Lots of timer congestion, had to push " + event + " back " + (time - eventTime) + "ms (# events: " + totalEvents + ")");
        }
        if ((timeToAdd = System.currentTimeMillis() - now) > 50L && this._log.shouldLog(30)) {
            this._log.warn("timer contention: took " + timeToAdd + "ms to add a job with " + totalEvents + " queued");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEvent(TimedEvent evt) {
        if (evt == null) {
            return false;
        }
        TreeMap treeMap = this._events;
        synchronized (treeMap) {
            Long when = (Long)this._eventTimes.remove(evt);
            if (when != null) {
                this._events.remove(when);
            }
            return null != when;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SimpleTimerRunner
    implements Runnable {
        private SimpleTimerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<TimedEvent> eventsToFire = new ArrayList<TimedEvent>(1);
            while (true) {
                try {
                    TreeMap treeMap = SimpleTimer.this._events;
                    synchronized (treeMap) {
                        long now = System.currentTimeMillis();
                        long nextEventDelay = -1L;
                        Object nextEvent = null;
                        while (SimpleTimer.this._events.size() > 0) {
                            Long when = (Long)SimpleTimer.this._events.firstKey();
                            if (when <= now) {
                                TimedEvent evt = (TimedEvent)SimpleTimer.this._events.remove(when);
                                if (evt == null) continue;
                                SimpleTimer.this._eventTimes.remove(evt);
                                eventsToFire.add(evt);
                                continue;
                            }
                            nextEventDelay = when - now;
                            nextEvent = SimpleTimer.this._events.get(when);
                            break;
                        }
                        if (eventsToFire.size() <= 0) {
                            if (nextEventDelay != -1L) {
                                if (SimpleTimer.this._log.shouldLog(10)) {
                                    SimpleTimer.this._log.debug("Next event in " + nextEventDelay + ": " + nextEvent);
                                }
                                SimpleTimer.this._events.wait(nextEventDelay);
                            } else {
                                SimpleTimer.this._events.wait();
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (Throwable t) {
                    if (SimpleTimer.this._log != null) {
                        SimpleTimer.this._log.log(50, "Uncaught exception in the SimpleTimer!", t);
                    }
                    System.err.println("Uncaught exception in SimpleTimer");
                    t.printStackTrace();
                }
                long now = System.currentTimeMillis();
                now -= now % 1000L;
                List list = SimpleTimer.this._readyEvents;
                synchronized (list) {
                    for (int i = 0; i < eventsToFire.size(); ++i) {
                        SimpleTimer.this._readyEvents.add(eventsToFire.get(i));
                    }
                    SimpleTimer.this._readyEvents.notifyAll();
                }
                if (SimpleTimer.this._occurredTime == now) {
                    SimpleTimer.this._occurredEventCount += eventsToFire.size();
                } else {
                    SimpleTimer.this._occurredTime = now;
                    if (SimpleTimer.this._occurredEventCount > 1000L) {
                        StringBuffer buf = new StringBuffer(128);
                        buf.append("Too many simpleTimerJobs (").append(SimpleTimer.this._occurredEventCount);
                        buf.append(") in a second!");
                        SimpleTimer.this._log.log(50, buf.toString());
                    }
                    SimpleTimer.this._occurredEventCount = 0L;
                }
                eventsToFire.clear();
            }
        }
    }

    public static interface TimedEvent {
        public void timeReached();
    }
}

