/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ShellCommand {
    private static final boolean CONSUME_OUTPUT = true;
    private static final boolean NO_CONSUME_OUTPUT = false;
    private static final boolean WAIT_FOR_EXIT_STATUS = true;
    private static final boolean NO_WAIT_FOR_EXIT_STATUS = false;
    private boolean _commandSuccessful;
    private CommandThread _commandThread;
    private InputStream _errorStream;
    private InputStream _inputStream;
    private boolean _isTimerRunning;
    private OutputStream _outputStream;
    private Process _process;
    private static final int BUFFER_SIZE = 1024;

    public void execute(String shellCommand) {
        this.execute(shellCommand, false, false);
    }

    public boolean executeAndWait(String shellCommand) {
        return this.execute(shellCommand, false, true);
    }

    public synchronized boolean executeAndWaitTimed(String shellCommand, int seconds) {
        this._commandThread = new CommandThread(this, shellCommand, false);
        this._commandThread.start();
        try {
            if (seconds > 0) {
                this._isTimerRunning = true;
                this.wait(seconds * 1000);
                this._isTimerRunning = false;
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._isTimerRunning = false;
        return this._commandSuccessful;
    }

    public void executeSilent(String shellCommand) throws IOException {
        Runtime.getRuntime().exec(shellCommand, null);
    }

    public boolean executeSilentAndWait(String shellCommand) {
        return this.execute(shellCommand, true, true);
    }

    public synchronized boolean executeSilentAndWaitTimed(String shellCommand, int seconds) {
        this._commandThread = new CommandThread(this, shellCommand, true);
        this._commandThread.start();
        try {
            if (seconds > 0) {
                this._isTimerRunning = true;
                this.wait(seconds * 1000);
                this._isTimerRunning = false;
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._isTimerRunning = false;
        return this._commandSuccessful;
    }

    public InputStream getErrorStream() {
        return this._errorStream;
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.err.println("Usage: ShellCommand commandline");
            return;
        }
        ShellCommand cmd = new ShellCommand();
        StringBuffer command = new StringBuffer(64);
        for (int i = 0; i < args.length; ++i) {
            command.append("\"").append(args[i]).append("\" ");
        }
        try {
            cmd.executeSilent(command.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean execute(String shellCommand, boolean consumeOutput, boolean waitForExitStatus) {
        block9: {
            try {
                this._process = Runtime.getRuntime().exec(shellCommand, null);
                if (consumeOutput) {
                    StreamConsumer processStderrConsumer = new StreamConsumer(this._process.getErrorStream());
                    processStderrConsumer.start();
                    StreamConsumer processStdoutConsumer = new StreamConsumer(this._process.getInputStream());
                    processStdoutConsumer.start();
                } else {
                    this._errorStream = this._process.getErrorStream();
                    this._inputStream = this._process.getInputStream();
                    this._outputStream = this._process.getOutputStream();
                    StreamReader processStderrReader = new StreamReader(this._errorStream);
                    processStderrReader.start();
                    StreamWriter processStdinWriter = new StreamWriter(this._outputStream);
                    processStdinWriter.start();
                    StreamReader processStdoutReader = new StreamReader(this._inputStream);
                    processStdoutReader.start();
                }
                if (!waitForExitStatus) break block9;
                try {
                    this._process.waitFor();
                }
                catch (Exception e) {
                    if (!consumeOutput) {
                        this.killStreams();
                    }
                    return false;
                }
                if (!consumeOutput) {
                    this.killStreams();
                }
                if (this._process.exitValue() > 0) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private void killStreams() {
        try {
            this._errorStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this._inputStream.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._errorStream = null;
        this._inputStream = null;
        this._outputStream = null;
    }

    private class StreamWriter
    extends Thread {
        private BufferedWriter bufferedWriter;
        private BufferedReader in;
        private OutputStreamWriter outputStreamWriter;

        public StreamWriter(OutputStream outputStream) {
            super("StreamWriter");
            this.outputStreamWriter = new OutputStreamWriter(outputStream);
            this.bufferedWriter = new BufferedWriter(this.outputStreamWriter);
        }

        public void run() {
            this.in = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (true) {
                    String input = this.in.readLine() + "\r\n";
                    this.bufferedWriter.write(input, 0, input.length());
                    this.bufferedWriter.flush();
                }
            }
            catch (Exception e) {
                try {
                    this.bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private class StreamReader
    extends Thread {
        private BufferedReader bufferedReader;
        private InputStreamReader inputStreamReader;

        public StreamReader(InputStream inputStream) {
            super("StreamReader");
            this.inputStreamReader = new InputStreamReader(inputStream);
            this.bufferedReader = new BufferedReader(this.inputStreamReader);
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            buffer = new char[1024];
            try {
                block2: while (true) {
                    if ((bytesRead = this.bufferedReader.read(buffer, 0, 1024)) == -1) {
                        continue;
                    }
                    i = 0;
                    while (true) {
                        if (i < bytesRead) ** break;
                        continue block2;
                        System.out.print(buffer[i]);
                        ++i;
                    }
                    break;
                }
            }
            catch (IOException var3_4) {
                return;
            }
        }
    }

    private class StreamConsumer
    extends Thread {
        private BufferedReader bufferedReader;
        private InputStreamReader inputStreamReader;

        public StreamConsumer(InputStream inputStream) {
            super("StreamConsumer");
            this.inputStreamReader = new InputStreamReader(inputStream);
            this.bufferedReader = new BufferedReader(this.inputStreamReader);
        }

        public void run() {
            try {
                String streamData;
                while ((streamData = this.bufferedReader.readLine()) != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CommandThread
    extends Thread {
        Object caller;
        boolean consumeOutput;
        String shellCommand;

        CommandThread(Object caller, String shellCommand, boolean consumeOutput) {
            super("CommandThread");
            this.caller = caller;
            this.shellCommand = shellCommand;
            this.consumeOutput = consumeOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ShellCommand.this._commandSuccessful = ShellCommand.this.execute(this.shellCommand, this.consumeOutput, true);
            if (ShellCommand.this._isTimerRunning) {
                Object object = this.caller;
                synchronized (object) {
                    this.caller.notifyAll();
                }
            }
        }
    }
}

