/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import org.xlattice.crypto.filters.BloomSHA1;

public class DecayingBloomFilter {
    private I2PAppContext _context;
    private Log _log;
    private BloomSHA1 _current;
    private BloomSHA1 _previous;
    private int _durationMs;
    private int _entryBytes;
    private byte[][] _extenders;
    private byte[] _extended;
    private byte[] _longToEntry;
    private long _longToEntryMask;
    private long _currentDuplicates;
    private boolean _keepDecaying;
    private DecayEvent _decayEvent;
    private static final boolean ALWAYS_MISS = false;
    static /* synthetic */ Class class$net$i2p$util$DecayingBloomFilter;

    public DecayingBloomFilter(I2PAppContext context, int durationMs, int entryBytes) {
        this._context = context;
        this._log = context.logManager().getLog(class$net$i2p$util$DecayingBloomFilter == null ? (class$net$i2p$util$DecayingBloomFilter = DecayingBloomFilter.class$("net.i2p.util.DecayingBloomFilter")) : class$net$i2p$util$DecayingBloomFilter);
        this._entryBytes = entryBytes;
        this._current = new BloomSHA1(23, 11);
        this._previous = new BloomSHA1(23, 11);
        this._durationMs = durationMs;
        int numExtenders = (32 + (entryBytes - 1)) / entryBytes - 1;
        if (numExtenders < 0) {
            numExtenders = 0;
        }
        this._extenders = new byte[numExtenders][entryBytes];
        for (int i = 0; i < numExtenders; ++i) {
            this._context.random().nextBytes(this._extenders[i]);
        }
        if (numExtenders > 0) {
            this._extended = new byte[32];
            this._longToEntry = new byte[this._entryBytes];
            this._longToEntryMask = (1L << (int)((long)this._entryBytes * 8L)) - 1L;
        }
        this._currentDuplicates = 0L;
        this._decayEvent = new DecayEvent();
        this._keepDecaying = true;
        SimpleTimer.getInstance().addEvent(this._decayEvent, this._durationMs);
    }

    public long getCurrentDuplicateCount() {
        return this._currentDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInsertedCount() {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this._current.size() + this._previous.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFalsePositiveRate() {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this._current.falsePositives();
        }
    }

    public boolean add(byte[] entry) {
        return this.add(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(byte[] entry, int off, int len) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        if (len != this._entryBytes) {
            throw new IllegalArgumentException("Bad entry [" + len + ", expected " + this._entryBytes + "]");
        }
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this.locked_add(entry, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long entry) {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            if (this._entryBytes <= 7) {
                entry = (entry ^ this._longToEntryMask) & Integer.MAX_VALUE | entry ^ this._longToEntryMask;
            }
            if (entry < 0L) {
                DataHelper.toLong(this._longToEntry, 0, this._entryBytes, 0L - entry);
                this._longToEntry[0] = (byte)(this._longToEntry[0] | 0x80);
            } else {
                DataHelper.toLong(this._longToEntry, 0, this._entryBytes, entry);
            }
            return this.locked_add(this._longToEntry, 0, this._longToEntry.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnown(long entry) {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            if (this._entryBytes <= 7) {
                entry = (entry ^ this._longToEntryMask) & Integer.MAX_VALUE | entry ^ this._longToEntryMask;
            }
            if (entry < 0L) {
                DataHelper.toLong(this._longToEntry, 0, this._entryBytes, 0L - entry);
                this._longToEntry[0] = (byte)(this._longToEntry[0] | 0x80);
            } else {
                DataHelper.toLong(this._longToEntry, 0, this._entryBytes, entry);
            }
            return this.locked_add(this._longToEntry, 0, this._longToEntry.length, false);
        }
    }

    private boolean locked_add(byte[] entry, int offset, int len) {
        return this.locked_add(entry, offset, len, true);
    }

    private boolean locked_add(byte[] entry, int offset, int len, boolean addIfNew) {
        if (this._extended != null) {
            System.arraycopy(entry, offset, this._extended, 0, len);
            for (int i = 0; i < this._extenders.length; ++i) {
                DataHelper.xor(entry, offset, this._extenders[i], 0, this._extended, this._entryBytes * (i + 1), this._entryBytes);
            }
            boolean seen = this._current.locked_member(this._extended);
            boolean bl = seen = seen || this._previous.locked_member(this._extended);
            if (seen) {
                ++this._currentDuplicates;
                return true;
            }
            if (addIfNew) {
                this._current.locked_insert(this._extended);
                this._previous.locked_insert(this._extended);
            }
            return false;
        }
        boolean seen = this._current.locked_member(entry, offset, len);
        boolean bl = seen = seen || this._previous.locked_member(entry, offset, len);
        if (seen) {
            ++this._currentDuplicates;
            return true;
        }
        if (addIfNew) {
            this._current.locked_insert(entry, offset, len);
            this._previous.locked_insert(entry, offset, len);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            this._current.clear();
            this._previous.clear();
            this._currentDuplicates = 0L;
        }
    }

    public void stopDecaying() {
        this._keepDecaying = false;
        SimpleTimer.getInstance().removeEvent(this._decayEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decay() {
        int currentCount = 0;
        long dups = 0L;
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            BloomSHA1 tmp = this._previous;
            currentCount = this._current.size();
            this._previous = this._current;
            this._current = tmp;
            this._current.clear();
            dups = this._currentDuplicates;
            this._currentDuplicates = 0L;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Decaying the filter after inserting " + currentCount + " elements and " + dups + " false positives");
        }
    }

    public static void main(String[] args) {
        int kbps = 256;
        int iterations = 100;
        DecayingBloomFilter.testByLong(kbps, iterations);
        DecayingBloomFilter.testByBytes(kbps, iterations);
    }

    public static void testByLong(int kbps, int numRuns) {
        int messages = 600 * kbps;
        Random r = new Random();
        DecayingBloomFilter filter = new DecayingBloomFilter(I2PAppContext.getGlobalContext(), 600000, 8);
        int falsePositives = 0;
        long totalTime = 0L;
        for (int j = 0; j < numRuns; ++j) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < messages; ++i) {
                if (!filter.add(r.nextLong())) continue;
                System.out.println("False positive " + ++falsePositives + " (testByLong j=" + j + " i=" + i + ")");
            }
            totalTime += System.currentTimeMillis() - start;
            filter.clear();
        }
        filter.stopDecaying();
        System.out.println("After " + numRuns + " runs pushing " + messages + " entries in " + DataHelper.formatDuration(totalTime / (long)numRuns) + " per run, there were " + falsePositives + " false positives");
    }

    public static void testByBytes(int kbps, int numRuns) {
        byte[][] iv = new byte[600 * kbps][16];
        Random r = new Random();
        for (int i = 0; i < iv.length; ++i) {
            r.nextBytes(iv[i]);
        }
        DecayingBloomFilter filter = new DecayingBloomFilter(I2PAppContext.getGlobalContext(), 600000, 16);
        int falsePositives = 0;
        long totalTime = 0L;
        for (int j = 0; j < numRuns; ++j) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < iv.length; ++i) {
                if (!filter.add(iv[i])) continue;
                System.out.println("False positive " + ++falsePositives + " (testByLong j=" + j + " i=" + i + ")");
            }
            totalTime += System.currentTimeMillis() - start;
            filter.clear();
        }
        filter.stopDecaying();
        System.out.println("After " + numRuns + " runs pushing " + iv.length + " entries in " + DataHelper.formatDuration(totalTime / (long)numRuns) + " per run, there were " + falsePositives + " false positives");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DecayEvent
    implements SimpleTimer.TimedEvent {
        private DecayEvent() {
        }

        public void timeReached() {
            if (DecayingBloomFilter.this._keepDecaying) {
                DecayingBloomFilter.this.decay();
                SimpleTimer.getInstance().addEvent(this, DecayingBloomFilter.this._durationMs);
            }
        }
    }
}

