/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.CreateSessionMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.DisconnectMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.ReceiveMessageBeginMessage;
import net.i2p.data.i2cp.ReceiveMessageEndMessage;
import net.i2p.data.i2cp.ReportAbuseMessage;
import net.i2p.data.i2cp.RequestLeaseSetMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionStatusMessage;
import net.i2p.data.i2cp.SetDateMessage;
import net.i2p.util.Log;

public class I2CPMessageHandler {
    private static final Log _log = new Log(class$net$i2p$data$i2cp$I2CPMessageHandler == null ? (class$net$i2p$data$i2cp$I2CPMessageHandler = I2CPMessageHandler.class$("net.i2p.data.i2cp.I2CPMessageHandler")) : class$net$i2p$data$i2cp$I2CPMessageHandler);
    static /* synthetic */ Class class$net$i2p$data$i2cp$I2CPMessageHandler;

    public static I2CPMessage readMessage(InputStream in) throws IOException, I2CPMessageException {
        try {
            int length = (int)DataHelper.readLong(in, 4);
            if (length < 0) {
                throw new I2CPMessageException("Invalid message length specified");
            }
            int type = (int)DataHelper.readLong(in, 1);
            I2CPMessage msg = I2CPMessageHandler.createMessage(in, length, type);
            msg.readMessage(in, length, type);
            return msg;
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error reading the message", dfe);
        }
    }

    private static I2CPMessage createMessage(InputStream in, int length, int type) throws IOException, I2CPMessageException {
        switch (type) {
            case 4: {
                return new CreateLeaseSetMessage();
            }
            case 1: {
                return new CreateSessionMessage();
            }
            case 3: {
                return new DestroySessionMessage();
            }
            case 30: {
                return new DisconnectMessage();
            }
            case 22: {
                return new MessageStatusMessage();
            }
            case 31: {
                return new MessagePayloadMessage();
            }
            case 6: {
                return new ReceiveMessageBeginMessage();
            }
            case 7: {
                return new ReceiveMessageEndMessage();
            }
            case 29: {
                return new ReportAbuseMessage();
            }
            case 21: {
                return new RequestLeaseSetMessage();
            }
            case 5: {
                return new SendMessageMessage();
            }
            case 20: {
                return new SessionStatusMessage();
            }
            case 32: {
                return new GetDateMessage();
            }
            case 33: {
                return new SetDateMessage();
            }
        }
        throw new I2CPMessageException("The type " + type + " is an unknown I2CP message");
    }

    public static void main(String[] args) {
        try {
            I2CPMessage msg = I2CPMessageHandler.readMessage(new FileInputStream(args[0]));
            System.out.println(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

