/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.i2p.crypto.DSAEngine;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.PublicKey;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Clock;
import net.i2p.util.Log;

public class LeaseSet
extends DataStructureImpl {
    private static final Log _log = new Log(class$net$i2p$data$LeaseSet == null ? (class$net$i2p$data$LeaseSet = LeaseSet.class$("net.i2p.data.LeaseSet")) : class$net$i2p$data$LeaseSet);
    private Destination _destination;
    private PublicKey _encryptionKey;
    private SigningPublicKey _signingKey;
    private List _leases;
    private Signature _signature;
    private volatile Hash _currentRoutingKey;
    private volatile byte[] _routingKeyGenMod;
    private boolean _receivedAsPublished;
    private static final long MAX_FUTURE_EXPIRATION = 31536000000L;
    static /* synthetic */ Class class$net$i2p$data$LeaseSet;

    public LeaseSet() {
        this.setDestination(null);
        this.setEncryptionKey(null);
        this.setSigningKey(null);
        this.setSignature(null);
        this.setRoutingKey(null);
        this._leases = new ArrayList();
        this._routingKeyGenMod = null;
        this._receivedAsPublished = false;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setDestination(Destination dest) {
        this._destination = dest;
    }

    public PublicKey getEncryptionKey() {
        return this._encryptionKey;
    }

    public void setEncryptionKey(PublicKey encryptionKey) {
        this._encryptionKey = encryptionKey;
    }

    public SigningPublicKey getSigningKey() {
        return this._signingKey;
    }

    public void setSigningKey(SigningPublicKey key) {
        this._signingKey = key;
    }

    public boolean getReceivedAsPublished() {
        return this._receivedAsPublished;
    }

    public void setReceivedAsPublished(boolean received) {
        this._receivedAsPublished = received;
    }

    public void addLease(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("erm, null lease");
        }
        if (lease.getGateway() == null) {
            throw new IllegalArgumentException("erm, lease has no gateway");
        }
        if (lease.getTunnelId() == null) {
            throw new IllegalArgumentException("erm, lease has no tunnel");
        }
        this._leases.add(lease);
    }

    public void removeLease(Lease lease) {
        this._leases.remove(lease);
    }

    public void removeLease(int index) {
        this._leases.remove(index);
    }

    public int getLeaseCount() {
        return this._leases.size();
    }

    public Lease getLease(int index) {
        return (Lease)this._leases.get(index);
    }

    public Signature getSignature() {
        return this._signature;
    }

    public void setSignature(Signature sig) {
        this._signature = sig;
    }

    public Hash getRoutingKey() {
        RoutingKeyGenerator gen = RoutingKeyGenerator.getInstance();
        if (gen.getModData() == null || this._routingKeyGenMod == null || !DataHelper.eq(gen.getModData(), this._routingKeyGenMod)) {
            this.setRoutingKey(gen.getRoutingKey(this.getDestination().calculateHash()));
            this._routingKeyGenMod = gen.getModData();
        }
        return this._currentRoutingKey;
    }

    public void setRoutingKey(Hash key) {
        this._currentRoutingKey = key;
    }

    public boolean validateRoutingKey() {
        Hash destKey = this.getDestination().calculateHash();
        Hash rk = RoutingKeyGenerator.getInstance().getRoutingKey(destKey);
        return rk.equals(this.getRoutingKey());
    }

    public long getEarliestLeaseDate() {
        long when = -1L;
        for (int i = 0; i < this.getLeaseCount(); ++i) {
            Lease lse = this.getLease(i);
            if (lse == null || lse.getEndDate() == null || when > 0L && lse.getEndDate().getTime() >= when) continue;
            when = lse.getEndDate().getTime();
        }
        return when;
    }

    public void sign(SigningPrivateKey key) throws DataFormatException {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            throw new DataFormatException("Not enough data to sign");
        }
        Signature sig = DSAEngine.getInstance().sign(bytes, key);
        this.setSignature(sig);
    }

    public boolean verifySignature() {
        if (this.getSignature() == null) {
            return false;
        }
        if (this.getDestination() == null) {
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            return false;
        }
        boolean signedByDest = DSAEngine.getInstance().verifySignature(this.getSignature(), data, this.getDestination().getSigningPublicKey());
        boolean signedByRevoker = false;
        if (!signedByDest) {
            signedByRevoker = DSAEngine.getInstance().verifySignature(this.getSignature(), data, this._signingKey);
        }
        return signedByDest || signedByRevoker;
    }

    public boolean verifySignature(SigningPublicKey signingKey) {
        if (this.getSignature() == null) {
            return false;
        }
        if (this.getDestination() == null) {
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            return false;
        }
        boolean signedByDest = DSAEngine.getInstance().verifySignature(this.getSignature(), data, this.getDestination().getSigningPublicKey());
        boolean signedByRevoker = false;
        if (!signedByDest) {
            signedByRevoker = DSAEngine.getInstance().verifySignature(this.getSignature(), data, signingKey);
        }
        return signedByDest || signedByRevoker;
    }

    public boolean isCurrent(long fudge) {
        long now = Clock.getInstance().now();
        long insane = now + 31536000000L;
        int cnt = this.getLeaseCount();
        for (int i = 0; i < cnt; ++i) {
            Lease l = this.getLease(i);
            if (l.getEndDate().getTime() > insane) {
                if (_log.shouldLog(30)) {
                    _log.warn("LeaseSet" + this.calculateHash() + " expires an insane amount in the future - skip it: " + l);
                }
                return false;
            }
            if (l.getEndDate().getTime() > now) {
                if (_log.shouldLog(10)) {
                    _log.debug("LeaseSet " + this.calculateHash() + " isn't exired: " + l);
                }
                return true;
            }
            if (l.getEndDate().getTime() <= now - fudge) continue;
            if (_log.shouldLog(10)) {
                _log.debug("LeaseSet " + this.calculateHash() + " isn't quite expired, but its within the fudge factor so we'll let it slide: " + l);
            }
            return true;
        }
        return false;
    }

    private byte[] getBytes() {
        int len = 773 + this._leases.size() * 44;
        ByteArrayOutputStream out = new ByteArrayOutputStream(len);
        try {
            if (this._destination == null || this._encryptionKey == null || this._signingKey == null || this._leases == null) {
                return null;
            }
            this._destination.writeBytes(out);
            this._encryptionKey.writeBytes(out);
            this._signingKey.writeBytes(out);
            DataHelper.writeLong(out, 1, this._leases.size());
            Iterator iter = this._leases.iterator();
            while (iter.hasNext()) {
                Lease lease = (Lease)iter.next();
                lease.writeBytes(out);
            }
        }
        catch (IOException ioe) {
            return null;
        }
        catch (DataFormatException dfe) {
            return null;
        }
        byte[] rv = out.toByteArray();
        return rv;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._destination = new Destination();
        this._destination.readBytes(in);
        this._encryptionKey = new PublicKey();
        this._encryptionKey.readBytes(in);
        this._signingKey = new SigningPublicKey();
        this._signingKey.readBytes(in);
        int numLeases = (int)DataHelper.readLong(in, 1);
        this._leases.clear();
        for (int i = 0; i < numLeases; ++i) {
            Lease lease = new Lease();
            lease.readBytes(in);
            this._leases.add(lease);
        }
        this._signature = new Signature();
        this._signature.readBytes(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null || this._encryptionKey == null || this._signingKey == null || this._leases == null || this._signature == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this._destination.writeBytes(out);
        this._encryptionKey.writeBytes(out);
        this._signingKey.writeBytes(out);
        DataHelper.writeLong(out, 1, this._leases.size());
        Iterator iter = this._leases.iterator();
        while (iter.hasNext()) {
            Lease lease = (Lease)iter.next();
            lease.writeBytes(out);
        }
        this._signature.writeBytes(out);
    }

    public int size() {
        return 771 + this._leases.size() * 44;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LeaseSet)) {
            return false;
        }
        LeaseSet ls = (LeaseSet)object;
        return DataHelper.eq(this.getEncryptionKey(), ls.getEncryptionKey()) && DataHelper.eq(this._leases, ls._leases) && DataHelper.eq(this.getSignature(), ls.getSignature()) && DataHelper.eq(this.getSigningKey(), ls.getSigningKey()) && DataHelper.eq(this.getDestination(), ls.getDestination());
    }

    public int hashCode() {
        return DataHelper.hashCode(this.getEncryptionKey()) + DataHelper.hashCode(this._leases) + DataHelper.hashCode(this.getSignature()) + DataHelper.hashCode(this.getSigningKey()) + DataHelper.hashCode(this.getDestination());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("[LeaseSet: ");
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tEncryptionKey: ").append(this.getEncryptionKey());
        buf.append("\n\tSigningKey: ").append(this.getSigningKey());
        buf.append("\n\tSignature: ").append(this.getSignature());
        buf.append("\n\tLeases: #").append(this.getLeaseCount());
        for (int i = 0; i < this.getLeaseCount(); ++i) {
            buf.append("\n\t\tLease (").append(i).append("): ").append(this.getLease(i));
        }
        buf.append("]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

