/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.SHA1;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;

public class DSAEngine {
    private Log _log;
    private I2PAppContext _context;
    static /* synthetic */ Class class$net$i2p$crypto$DSAEngine;

    public DSAEngine(I2PAppContext context) {
        this._log = context.logManager().getLog(class$net$i2p$crypto$DSAEngine == null ? (class$net$i2p$crypto$DSAEngine = DSAEngine.class$("net.i2p.crypto.DSAEngine")) : class$net$i2p$crypto$DSAEngine);
        this._context = context;
    }

    public static DSAEngine getInstance() {
        return I2PAppContext.getGlobalContext().dsa();
    }

    public boolean verifySignature(Signature signature, byte[] signedData, SigningPublicKey verifyingKey) {
        return this.verifySignature(signature, signedData, 0, signedData.length, verifyingKey);
    }

    public boolean verifySignature(Signature signature, byte[] signedData, int offset, int size, SigningPublicKey verifyingKey) {
        return this.verifySignature(signature, DSAEngine.calculateHash(signedData, offset, size), verifyingKey);
    }

    public boolean verifySignature(Signature signature, InputStream in, SigningPublicKey verifyingKey) {
        return this.verifySignature(signature, this.calculateHash(in), verifyingKey);
    }

    public boolean verifySignature(Signature signature, Hash hash, SigningPublicKey verifyingKey) {
        long start = this._context.clock().now();
        try {
            byte[] sigbytes = signature.getData();
            byte[] rbytes = new byte[20];
            byte[] sbytes = new byte[20];
            for (int x = 0; x < 40; ++x) {
                if (x < 20) {
                    rbytes[x] = sigbytes[x];
                    continue;
                }
                sbytes[x - 20] = sigbytes[x];
            }
            NativeBigInteger s = new NativeBigInteger(1, sbytes);
            NativeBigInteger r = new NativeBigInteger(1, rbytes);
            NativeBigInteger y = new NativeBigInteger(1, verifyingKey.getData());
            BigInteger w = null;
            try {
                w = s.modInverse(CryptoConstants.dsaq);
            }
            catch (ArithmeticException ae) {
                return false;
            }
            byte[] data = hash.getData();
            NativeBigInteger bi = new NativeBigInteger(1, data);
            BigInteger u1 = bi.multiply(w).mod(CryptoConstants.dsaq);
            BigInteger u2 = r.multiply(w).mod(CryptoConstants.dsaq);
            BigInteger modval = CryptoConstants.dsag.modPow(u1, CryptoConstants.dsap);
            BigInteger modmulval = modval.multiply(((BigInteger)y).modPow(u2, CryptoConstants.dsap));
            BigInteger v = modmulval.mod(CryptoConstants.dsap).mod(CryptoConstants.dsaq);
            boolean ok = v.compareTo(r) == 0;
            long diff = this._context.clock().now() - start;
            if (diff > 1000L && this._log.shouldLog(30)) {
                this._log.warn("Took too long to verify the signature (" + diff + "ms)");
            }
            return ok;
        }
        catch (Exception e) {
            this._log.log(50, "Error verifying the signature", e);
            return false;
        }
    }

    public Signature sign(byte[] data, SigningPrivateKey signingKey) {
        return this.sign(data, 0, data.length, signingKey);
    }

    public Signature sign(byte[] data, int offset, int length, SigningPrivateKey signingKey) {
        if (signingKey == null || data == null || data.length <= 0) {
            return null;
        }
        Hash h = DSAEngine.calculateHash(data, offset, length);
        return this.sign(h, signingKey);
    }

    public Signature sign(InputStream in, SigningPrivateKey signingKey) {
        if (signingKey == null || in == null) {
            return null;
        }
        Hash h = this.calculateHash(in);
        return this.sign(h, signingKey);
    }

    public Signature sign(Hash hash, SigningPrivateKey signingKey) {
        int i;
        BigInteger k;
        if (signingKey == null || hash == null) {
            return null;
        }
        long start = this._context.clock().now();
        Signature sig = new Signature();
        boolean ok = false;
        do {
            ok = (k = new BigInteger(160, this._context.random())).compareTo(CryptoConstants.dsaq) != 1;
        } while (!(ok = ok && !k.equals(BigInteger.ZERO)));
        BigInteger r = CryptoConstants.dsag.modPow(k, CryptoConstants.dsap).mod(CryptoConstants.dsaq);
        BigInteger kinv = k.modInverse(CryptoConstants.dsaq);
        NativeBigInteger M = new NativeBigInteger(1, hash.getData());
        NativeBigInteger x = new NativeBigInteger(1, signingKey.getData());
        BigInteger s = kinv.multiply(M.add(x.multiply(r))).mod(CryptoConstants.dsaq);
        byte[] rbytes = r.toByteArray();
        byte[] sbytes = s.toByteArray();
        byte[] out = new byte[40];
        this._context.random().harvester().feedEntropy("DSA.sign", rbytes, 0, rbytes.length);
        if (rbytes.length == 20) {
            for (i = 0; i < 20; ++i) {
                out[i] = rbytes[i];
            }
        } else if (rbytes.length == 21) {
            for (i = 0; i < 20; ++i) {
                out[i] = rbytes[i + 1];
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Using short rbytes.length [" + rbytes.length + "]");
            }
            for (i = 0; i < rbytes.length; ++i) {
                out[i + 20 - rbytes.length] = rbytes[i];
            }
        }
        if (sbytes.length == 20) {
            for (i = 0; i < 20; ++i) {
                out[i + 20] = sbytes[i];
            }
        } else if (sbytes.length == 21) {
            for (i = 0; i < 20; ++i) {
                out[i + 20] = sbytes[i + 1];
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Using short sbytes.length [" + sbytes.length + "]");
            }
            for (i = 0; i < sbytes.length; ++i) {
                out[i + 20 + 20 - sbytes.length] = sbytes[i];
            }
        }
        sig.setData(out);
        long diff = this._context.clock().now() - start;
        if (diff > 1000L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to sign (" + diff + "ms)");
        }
        return sig;
    }

    public Hash calculateHash(InputStream in) {
        SHA1 digest = new SHA1();
        byte[] buf = new byte[64];
        int read = 0;
        try {
            while ((read = in.read(buf)) != -1) {
                digest.engineUpdate(buf, 0, read);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to hash the stream", ioe);
            }
            return null;
        }
        return new Hash(digest.engineDigest());
    }

    public static Hash calculateHash(byte[] source, int offset, int len) {
        SHA1 h = new SHA1();
        h.engineUpdate(source, offset, len);
        byte[] digested = h.digest();
        return new Hash(digested);
    }

    public static void main(String[] args) {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] data = new byte[4096];
        ctx.random().nextBytes(data);
        Object[] keys = ctx.keyGenerator().generateSigningKeypair();
        try {
            for (int i = 0; i < 10; ++i) {
                Signature sig = ctx.dsa().sign(data, (SigningPrivateKey)keys[1]);
                boolean ok = ctx.dsa().verifySignature(sig, data, (SigningPublicKey)keys[0]);
                System.out.println("OK: " + ok);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ctx.random().saveSeed();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

