/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.util.Log;

public class AESOutputStream
extends FilterOutputStream {
    private Log _log;
    private I2PAppContext _context;
    private SessionKey _key;
    private byte[] _lastBlock;
    private byte[] _unencryptedBuf;
    private byte[] _writeBlock;
    private int _writesSinceCommit;
    private long _cumulativeProvided;
    private long _cumulativeWritten;
    private long _cumulativePadding;
    public static final float EXPANSION_FACTOR = 1.0625f;
    private static final int BLOCK_SIZE = 16;
    private static final int MAX_BUF = 256;
    static /* synthetic */ Class class$net$i2p$crypto$AESOutputStream;

    public AESOutputStream(I2PAppContext context, OutputStream source, SessionKey key, byte[] iv) {
        super(source);
        this._context = context;
        this._log = context.logManager().getLog(class$net$i2p$crypto$AESOutputStream == null ? (class$net$i2p$crypto$AESOutputStream = AESOutputStream.class$("net.i2p.crypto.AESOutputStream")) : class$net$i2p$crypto$AESOutputStream);
        this._key = key;
        this._lastBlock = new byte[16];
        System.arraycopy(iv, 0, this._lastBlock, 0, 16);
        this._unencryptedBuf = new byte[256];
        this._writeBlock = new byte[16];
        this._writesSinceCommit = 0;
    }

    public void write(int val) throws IOException {
        ++this._cumulativeProvided;
        this._unencryptedBuf[this._writesSinceCommit++] = (byte)(val & 0xFF);
        if (this._writesSinceCommit == this._unencryptedBuf.length) {
            this.doFlush();
        }
    }

    public void write(byte[] src) throws IOException {
        this.write(src, 0, src.length);
    }

    public void write(byte[] src, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(src[i + off]);
        }
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
        if (this._log.shouldLog(10)) {
            this._log.debug("Cumulative bytes provided to this stream / written out / padded: " + this._cumulativeProvided + "/" + this._cumulativeWritten + "/" + this._cumulativePadding);
        }
    }

    public void flush() throws IOException {
        this.doFlush();
        this.out.flush();
    }

    private void doFlush() throws IOException {
        if (this._log.shouldLog(20)) {
            this._log.info("doFlush(): writesSinceCommit=" + this._writesSinceCommit);
        }
        this.writeEncrypted();
        this._writesSinceCommit = 0;
    }

    private void writeEncrypted() throws IOException {
        int numBlocks = this._writesSinceCommit / 15;
        if (this._log.shouldLog(20)) {
            this._log.info("writeE(): #=" + this._writesSinceCommit + " blocks=" + numBlocks);
        }
        for (int i = 0; i < numBlocks; ++i) {
            DataHelper.xor(this._unencryptedBuf, i * 15, this._lastBlock, 0, this._writeBlock, 0, 15);
            this._writeBlock[15] = (byte)(this._lastBlock[15] ^ 1);
            this._context.aes().encrypt(this._writeBlock, 0, this._writeBlock, 0, this._key, this._lastBlock, 16);
            this.out.write(this._writeBlock);
            System.arraycopy(this._writeBlock, 0, this._lastBlock, 0, 16);
            this._cumulativeWritten += 16L;
            ++this._cumulativePadding;
        }
        if (this._writesSinceCommit % 15 != 0) {
            int remainingBytes = this._writesSinceCommit - numBlocks * 15;
            int paddingBytes = 16 - remainingBytes;
            if (this._log.shouldLog(10)) {
                this._log.debug("Padding " + this._writesSinceCommit + " with " + paddingBytes + " bytes in " + (numBlocks + 1) + " blocks");
            }
            System.arraycopy(this._unencryptedBuf, numBlocks * 15, this._writeBlock, 0, remainingBytes);
            Arrays.fill(this._writeBlock, remainingBytes, 16, (byte)paddingBytes);
            DataHelper.xor(this._writeBlock, 0, this._lastBlock, 0, this._writeBlock, 0, 16);
            this._context.aes().encrypt(this._writeBlock, 0, this._writeBlock, 0, this._key, this._lastBlock, 16);
            this.out.write(this._writeBlock);
            System.arraycopy(this._writeBlock, 0, this._lastBlock, 0, 16);
            this._cumulativePadding += (long)paddingBytes;
            this._cumulativeWritten += 16L;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

