/*
 * Decompiled with CFR 0.152.
 */
package net.i2p;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.PetNameDB;
import net.i2p.crypto.AESEngine;
import net.i2p.crypto.CryptixAESEngine;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.DummyDSAEngine;
import net.i2p.crypto.DummyElGamalEngine;
import net.i2p.crypto.ElGamalAESEngine;
import net.i2p.crypto.ElGamalEngine;
import net.i2p.crypto.HMAC256Generator;
import net.i2p.crypto.HMACGenerator;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.PersistentSessionKeyManager;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.stat.StatManager;
import net.i2p.util.Clock;
import net.i2p.util.FortunaRandomSource;
import net.i2p.util.LogManager;
import net.i2p.util.RandomSource;

public class I2PAppContext {
    protected static I2PAppContext _globalAppContext;
    private Properties _overrideProps;
    private StatManager _statManager;
    private SessionKeyManager _sessionKeyManager;
    private NamingService _namingService;
    private PetNameDB _petnameDb;
    private ElGamalEngine _elGamalEngine;
    private ElGamalAESEngine _elGamalAESEngine;
    private AESEngine _AESEngine;
    private LogManager _logManager;
    private HMACGenerator _hmac;
    private HMAC256Generator _hmac256;
    private SHA256Generator _sha;
    protected Clock _clock;
    private DSAEngine _dsa;
    private RoutingKeyGenerator _routingKeyGenerator;
    private RandomSource _random;
    private KeyGenerator _keyGenerator;
    private volatile boolean _statManagerInitialized;
    private volatile boolean _sessionKeyManagerInitialized;
    private volatile boolean _namingServiceInitialized;
    private volatile boolean _petnameDbInitialized;
    private volatile boolean _elGamalEngineInitialized;
    private volatile boolean _elGamalAESEngineInitialized;
    private volatile boolean _AESEngineInitialized;
    private volatile boolean _logManagerInitialized;
    private volatile boolean _hmacInitialized;
    private volatile boolean _hmac256Initialized;
    private volatile boolean _shaInitialized;
    protected volatile boolean _clockInitialized;
    private volatile boolean _dsaInitialized;
    private volatile boolean _routingKeyGeneratorInitialized;
    private volatile boolean _randomInitialized;
    private volatile boolean _keyGeneratorInitialized;
    static /* synthetic */ Class class$net$i2p$I2PAppContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I2PAppContext getGlobalContext() {
        Class clazz = class$net$i2p$I2PAppContext == null ? (class$net$i2p$I2PAppContext = I2PAppContext.class$("net.i2p.I2PAppContext")) : class$net$i2p$I2PAppContext;
        synchronized (clazz) {
            if (_globalAppContext == null) {
                _globalAppContext = new I2PAppContext(false, null);
            }
        }
        return _globalAppContext;
    }

    public I2PAppContext() {
        this(true, null);
    }

    public I2PAppContext(Properties envProps) {
        this(true, envProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private I2PAppContext(boolean doInit, Properties envProps) {
        if (doInit) {
            Class clazz = class$net$i2p$I2PAppContext == null ? (class$net$i2p$I2PAppContext = I2PAppContext.class$("net.i2p.I2PAppContext")) : class$net$i2p$I2PAppContext;
            synchronized (clazz) {
                if (_globalAppContext == null) {
                    _globalAppContext = this;
                }
            }
        }
        this._overrideProps = envProps;
        this._statManager = null;
        this._sessionKeyManager = null;
        this._namingService = null;
        this._petnameDb = null;
        this._elGamalEngine = null;
        this._elGamalAESEngine = null;
        this._logManager = null;
        this._statManagerInitialized = false;
        this._sessionKeyManagerInitialized = false;
        this._namingServiceInitialized = false;
        this._elGamalEngineInitialized = false;
        this._elGamalAESEngineInitialized = false;
        this._logManagerInitialized = false;
    }

    public String getProperty(String propName) {
        if (this._overrideProps != null && this._overrideProps.containsKey(propName)) {
            return this._overrideProps.getProperty(propName);
        }
        return System.getProperty(propName);
    }

    public String getProperty(String propName, String defaultValue) {
        if (this._overrideProps != null && this._overrideProps.containsKey(propName)) {
            return this._overrideProps.getProperty(propName, defaultValue);
        }
        return System.getProperty(propName, defaultValue);
    }

    public Set getPropertyNames() {
        HashSet<Object> names = new HashSet<Object>(System.getProperties().keySet());
        if (this._overrideProps != null) {
            names.addAll(this._overrideProps.keySet());
        }
        return names;
    }

    public StatManager statManager() {
        if (!this._statManagerInitialized) {
            this.initializeStatManager();
        }
        return this._statManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStatManager() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._statManager == null) {
                this._statManager = new StatManager(this);
            }
            this._statManagerInitialized = true;
        }
    }

    public SessionKeyManager sessionKeyManager() {
        if (!this._sessionKeyManagerInitialized) {
            this.initializeSessionKeyManager();
        }
        return this._sessionKeyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSessionKeyManager() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._sessionKeyManager == null) {
                this._sessionKeyManager = new PersistentSessionKeyManager(this);
            }
            this._sessionKeyManagerInitialized = true;
        }
    }

    public NamingService namingService() {
        if (!this._namingServiceInitialized) {
            this.initializeNamingService();
        }
        return this._namingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNamingService() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._namingService == null) {
                this._namingService = NamingService.createInstance(this);
            }
            this._namingServiceInitialized = true;
        }
    }

    public PetNameDB petnameDb() {
        if (!this._petnameDbInitialized) {
            this.initializePetnameDb();
        }
        return this._petnameDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePetnameDb() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._petnameDb == null) {
                this._petnameDb = new PetNameDB();
            }
            this._petnameDbInitialized = true;
        }
    }

    public ElGamalEngine elGamalEngine() {
        if (!this._elGamalEngineInitialized) {
            this.initializeElGamalEngine();
        }
        return this._elGamalEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeElGamalEngine() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._elGamalEngine == null) {
                this._elGamalEngine = "off".equals(this.getProperty("i2p.encryption", "on")) ? new DummyElGamalEngine(this) : new ElGamalEngine(this);
            }
            this._elGamalEngineInitialized = true;
        }
    }

    public ElGamalAESEngine elGamalAESEngine() {
        if (!this._elGamalAESEngineInitialized) {
            this.initializeElGamalAESEngine();
        }
        return this._elGamalAESEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeElGamalAESEngine() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._elGamalAESEngine == null) {
                this._elGamalAESEngine = new ElGamalAESEngine(this);
            }
            this._elGamalAESEngineInitialized = true;
        }
    }

    public AESEngine aes() {
        if (!this._AESEngineInitialized) {
            this.initializeAESEngine();
        }
        return this._AESEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAESEngine() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._AESEngine == null) {
                this._AESEngine = "off".equals(this.getProperty("i2p.encryption", "on")) ? new AESEngine(this) : new CryptixAESEngine(this);
            }
            this._AESEngineInitialized = true;
        }
    }

    public LogManager logManager() {
        if (!this._logManagerInitialized) {
            this.initializeLogManager();
        }
        return this._logManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLogManager() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._logManager == null) {
                this._logManager = new LogManager(this);
            }
            this._logManagerInitialized = true;
        }
    }

    public HMACGenerator hmac() {
        if (!this._hmacInitialized) {
            this.initializeHMAC();
        }
        return this._hmac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHMAC() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._hmac == null) {
                this._hmac = new HMACGenerator(this);
            }
            this._hmacInitialized = true;
        }
    }

    public HMAC256Generator hmac256() {
        if (!this._hmac256Initialized) {
            this.initializeHMAC256();
        }
        return this._hmac256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHMAC256() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._hmac256 == null) {
                this._hmac256 = new HMAC256Generator(this);
            }
            this._hmac256Initialized = true;
        }
    }

    public SHA256Generator sha() {
        if (!this._shaInitialized) {
            this.initializeSHA();
        }
        return this._sha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSHA() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._sha == null) {
                this._sha = new SHA256Generator(this);
            }
            this._shaInitialized = true;
        }
    }

    public DSAEngine dsa() {
        if (!this._dsaInitialized) {
            this.initializeDSA();
        }
        return this._dsa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDSA() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._dsa == null) {
                this._dsa = "off".equals(this.getProperty("i2p.encryption", "on")) ? new DummyDSAEngine(this) : new DSAEngine(this);
            }
            this._dsaInitialized = true;
        }
    }

    public KeyGenerator keyGenerator() {
        if (!this._keyGeneratorInitialized) {
            this.initializeKeyGenerator();
        }
        return this._keyGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeyGenerator() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._keyGenerator == null) {
                this._keyGenerator = new KeyGenerator(this);
            }
            this._keyGeneratorInitialized = true;
        }
    }

    public Clock clock() {
        if (!this._clockInitialized) {
            this.initializeClock();
        }
        return this._clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeClock() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._clock == null) {
                this._clock = new Clock(this);
            }
            this._clockInitialized = true;
        }
    }

    public RoutingKeyGenerator routingKeyGenerator() {
        if (!this._routingKeyGeneratorInitialized) {
            this.initializeRoutingKeyGenerator();
        }
        return this._routingKeyGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRoutingKeyGenerator() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._routingKeyGenerator == null) {
                this._routingKeyGenerator = new RoutingKeyGenerator(this);
            }
            this._routingKeyGeneratorInitialized = true;
        }
    }

    public RandomSource random() {
        if (!this._randomInitialized) {
            this.initializeRandom();
        }
        return this._random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRandom() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._random == null) {
                this._random = new FortunaRandomSource(this);
            }
            this._randomInitialized = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

