/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.SchedulerClosed;
import net.i2p.client.streaming.SchedulerClosing;
import net.i2p.client.streaming.SchedulerConnectedBulk;
import net.i2p.client.streaming.SchedulerConnecting;
import net.i2p.client.streaming.SchedulerDead;
import net.i2p.client.streaming.SchedulerHardDisconnected;
import net.i2p.client.streaming.SchedulerImpl;
import net.i2p.client.streaming.SchedulerPreconnect;
import net.i2p.client.streaming.SchedulerReceived;
import net.i2p.client.streaming.TaskScheduler;
import net.i2p.util.Log;

class SchedulerChooser {
    private I2PAppContext _context;
    private Log _log;
    private TaskScheduler _nullScheduler;
    private List _schedulers;
    static /* synthetic */ Class class$net$i2p$client$streaming$SchedulerChooser;
    static /* synthetic */ Class class$net$i2p$client$streaming$SchedulerChooser$NullScheduler;

    public SchedulerChooser(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(class$net$i2p$client$streaming$SchedulerChooser == null ? (class$net$i2p$client$streaming$SchedulerChooser = SchedulerChooser.class$("net.i2p.client.streaming.SchedulerChooser")) : class$net$i2p$client$streaming$SchedulerChooser);
        this._schedulers = this.createSchedulers();
        this._nullScheduler = new NullScheduler();
    }

    public TaskScheduler getScheduler(Connection con) {
        for (int i = 0; i < this._schedulers.size(); ++i) {
            TaskScheduler scheduler = (TaskScheduler)this._schedulers.get(i);
            if (!scheduler.accept(con)) continue;
            return scheduler;
        }
        return this._nullScheduler;
    }

    private List createSchedulers() {
        ArrayList<SchedulerImpl> rv = new ArrayList<SchedulerImpl>(8);
        rv.add(new SchedulerHardDisconnected(this._context));
        rv.add(new SchedulerPreconnect(this._context));
        rv.add(new SchedulerConnecting(this._context));
        rv.add(new SchedulerReceived(this._context));
        rv.add(new SchedulerConnectedBulk(this._context));
        rv.add(new SchedulerClosing(this._context));
        rv.add(new SchedulerClosed(this._context));
        rv.add(new SchedulerDead(this._context));
        return rv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NullScheduler
    implements TaskScheduler {
        private Log _log;

        public NullScheduler() {
            this._log = SchedulerChooser.this._context.logManager().getLog(class$net$i2p$client$streaming$SchedulerChooser$NullScheduler == null ? (class$net$i2p$client$streaming$SchedulerChooser$NullScheduler = SchedulerChooser.class$("net.i2p.client.streaming.SchedulerChooser$NullScheduler")) : class$net$i2p$client$streaming$SchedulerChooser$NullScheduler);
        }

        public void eventOccurred(Connection con) {
            this._log.log(50, "Yell at jrandom: Event occurred on " + con, (Throwable)new Exception("source"));
        }

        public boolean accept(Connection con) {
            return true;
        }
    }
}

