/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.URI;
import phex.common.log.NLogger;
import phex.metalink.MetalinkParser;
import phex.servent.Servent;
import phex.share.FileRescanRunner;
import phex.utils.MagmaParser;
import phex.utils.RSSParser;

public final class InternalFileHandler {
    public static void magmaReadout(File file) {
        try {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            MagmaParser parser = new MagmaParser(inStream);
            parser.start();
            List magnetList = parser.getMagnets();
            String relativeDownloadDir = parser.getMagmaName();
            Iterator iter = magnetList.iterator();
            FileRescanRunner.sync();
            while (iter.hasNext()) {
                String magnet = (String)iter.next();
                URI uri = new URI(magnet, true);
                if (relativeDownloadDir.length() == 0) {
                    InternalFileHandler.downloadUri(uri);
                    continue;
                }
                InternalFileHandler.downloadUri(uri, relativeDownloadDir);
            }
        }
        catch (IOException exp) {
            NLogger.warn(InternalFileHandler.class, (Object)exp.getMessage(), (Throwable)exp);
        }
    }

    public static void rssReadout(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            RSSParser parser = new RSSParser(reader);
            parser.start();
            List magnetList = parser.getMagnets();
            Iterator iter = magnetList.iterator();
            FileRescanRunner.sync();
            while (iter.hasNext()) {
                String magnet = (String)iter.next();
                URI uri = new URI(magnet, true);
                InternalFileHandler.downloadUri(uri);
            }
        }
        catch (IOException exp) {
            NLogger.error(InternalFileHandler.class, (Object)exp.getMessage(), (Throwable)exp);
        }
    }

    public static void metalinkReadout(File metalinkFile) {
        if (!metalinkFile.exists()) {
            return;
        }
        List<URI> magnetList = MetalinkParser.parseMagnetUriFromFile(metalinkFile);
        if (magnetList == null || magnetList.isEmpty()) {
            return;
        }
        FileRescanRunner.sync();
        for (URI magnet : magnetList) {
            InternalFileHandler.downloadUri(magnet);
        }
    }

    public static void scheduledReadout(URI uri, long time) {
        InternalFileHandler.downloadUri(uri);
    }

    private static void downloadUri(URI uri) {
        try {
            Servent.getInstance().getDownloadService().addFileToDownload(uri, true);
        }
        catch (IOException exp) {
            NLogger.warn(InternalFileHandler.class, (Object)exp.getMessage(), (Throwable)exp);
        }
    }

    private static void downloadUri(URI uri, String relativeDownloadDir) {
        try {
            Servent.getInstance().getDownloadService().addFileToDownload(uri, relativeDownloadDir, true);
        }
        catch (IOException exp) {
            NLogger.warn(InternalFileHandler.class, (Object)exp.getMessage(), (Throwable)exp);
        }
    }
}

