/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.IOException;
import phex.common.Environment;
import phex.common.bandwidth.BandwidthController;
import phex.common.log.NLogger;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.io.buffer.ByteBuffer;
import phex.msg.PushRequestMsg;
import phex.net.connection.Connection;
import phex.net.connection.SocketFactory;
import phex.net.repres.SocketFacade;
import phex.servent.Servent;
import phex.share.HttpRequestDispatcher;
import phex.share.ShareFile;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;
import phex.upload.UploadManager;
import phex.utils.StringUtils;
import phex.utils.URLCodecUtils;

public class PushWorker
implements Runnable {
    private static final int PUSH_TIMEOUT = 45000;
    private final UploadManager uploadMgr;
    private final PushRequestMsg pushMsg;
    private Connection connection;

    public PushWorker(PushRequestMsg msg, UploadManager uploadMgr) {
        this.uploadMgr = uploadMgr;
        this.pushMsg = msg;
        Environment.getInstance().executeOnThreadPool(this, "PushWorker-" + Integer.toHexString(this.hashCode()));
        StatisticsManager statMgr = Servent.getInstance().getStatisticsService();
        ((SimpleStatisticProvider)statMgr.getStatisticProvider("PushUploadAttemptsProvider")).increment(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            HTTPRequest httpRequest = this.connectAndGetRequest();
            if (httpRequest == null) {
                StatisticsManager statMgr = Servent.getInstance().getStatisticsService();
                ((SimpleStatisticProvider)statMgr.getStatisticProvider("PushUploadFailureProvider")).increment(1);
                return;
            }
            this.handleRequest(httpRequest);
            NLogger.debug(PushWorker.class, (Object)"PushWorker finished");
        }
        catch (Exception exp) {
            NLogger.error(PushWorker.class, (Object)exp, (Throwable)exp);
            return;
        }
        finally {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    private void handleRequest(HTTPRequest httpRequest) {
        NLogger.debug(PushWorker.class, (Object)("Handle PUSH request: " + httpRequest.buildHTTPRequestString()));
        StatisticsManager statMgr = Servent.getInstance().getStatisticsService();
        ((SimpleStatisticProvider)statMgr.getStatisticProvider("PushUploadSucessProvider")).increment(1);
        if (httpRequest.isGnutellaRequest()) {
            this.uploadMgr.handleUploadRequest(this.connection, httpRequest);
        } else {
            new HttpRequestDispatcher().httpRequestHandler(this.connection, httpRequest);
        }
    }

    private HTTPRequest connectAndGetRequest() {
        try {
            NLogger.debug(PushWorker.class, (Object)("Try PUSH connect to: " + this.pushMsg.getRequestAddress()));
            SocketFacade sock = SocketFactory.connect(this.pushMsg.getRequestAddress(), 45000);
            BandwidthController bwController = this.uploadMgr.getUploadBandwidthController();
            this.connection = new Connection(sock, bwController);
            this.sendGIV(this.connection);
            HTTPRequest httpRequest = HTTPProcessor.parseHTTPRequest(this.connection);
            return httpRequest;
        }
        catch (IOException exp) {
            NLogger.debug(PushWorker.class, (Object)exp);
            return null;
        }
        catch (HTTPMessageException exp) {
            NLogger.debug(PushWorker.class, (Object)exp);
            return null;
        }
    }

    private void sendGIV(Connection connection) throws IOException {
        Servent servent = Servent.getInstance();
        ShareFile sfile = servent.getSharedFilesService().getFileByIndex((int)this.pushMsg.getFileIndex());
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("GIV ");
        buffer.append(this.pushMsg.getFileIndex());
        buffer.append(':');
        buffer.append(this.pushMsg.getClientGUID().toHexString());
        buffer.append('/');
        if (sfile != null) {
            buffer.append(URLCodecUtils.encodeURL(sfile.getFileName()));
        } else {
            buffer.append("file");
        }
        buffer.append("\n\n");
        NLogger.debug(PushWorker.class, (Object)("Send GIV: " + buffer.toString()));
        connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(buffer.toString())));
        connection.flush();
    }
}

