/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.List;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.http.Range;
import phex.net.repres.PresentationManager;
import phex.share.SharedResource;
import phex.thex.FileHashCalculationHandler;
import phex.thex.ShareFileThexData;
import phex.xml.sax.share.DAlternateLocation;
import phex.xml.sax.share.DSharedFile;

public class ShareFile
extends SharedResource {
    private int fileIndex;
    private long fileSize;
    private URN urn;
    private ShareFileThexData thexData;
    private int searchCount;
    private int uploadCount;
    private AltLocContainer alternateLocations;
    private Long networkCreateTime;

    public ShareFile(File aFile) {
        super(aFile);
        this.fileSize = this.systemFile.length();
        this.searchCount = 0;
        this.uploadCount = 0;
        this.networkCreateTime = aFile.lastModified();
    }

    protected ShareFile(long aFileSize) {
        this.fileSize = aFileSize;
    }

    public URN getURN() {
        return this.urn;
    }

    public void setURN(URN urn) {
        this.urn = urn;
    }

    public String getSha1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int index) {
        this.fileIndex = index;
    }

    public ShareFileThexData getThexData(FileHashCalculationHandler hashCalcQueue) {
        if (this.thexData == null && this.urn != null && hashCalcQueue != null && this.fileSize > 0L) {
            hashCalcQueue.queueThexCalculation(this);
        }
        return this.thexData;
    }

    public void setThexData(ShareFileThexData thexData) {
        this.thexData = thexData;
    }

    public Long getNetworkCreateTime() {
        return this.networkCreateTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Range.RangeAvailability getRangeAvailableStatus(Range range) {
        long startOffset = range.getStartOffset(this.fileSize);
        if (startOffset < 0L || startOffset >= this.fileSize) {
            return Range.RangeAvailability.RANGE_NOT_SATISFIABLE;
        }
        return Range.RangeAvailability.RANGE_AVAILABLE;
    }

    public AltLocContainer getAltLocContainer() {
        if (this.alternateLocations == null && this.urn != null) {
            this.alternateLocations = new AltLocContainer(this.urn);
        }
        return this.alternateLocations;
    }

    public int getAltLocCount() {
        if (this.alternateLocations == null) {
            return 0;
        }
        return this.alternateLocations.getSize();
    }

    public int getSearchCount() {
        return this.searchCount;
    }

    public void incSearchCount() {
        ++this.searchCount;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void incUploadCount() {
        ++this.uploadCount;
    }

    public void updateFromCache(DSharedFile dFile) {
        this.searchCount = dFile.getHitCount();
        this.uploadCount = dFile.getUploadCount();
        this.urn = new URN("urn:sha1:" + dFile.getSha1());
        this.networkCreateTime = dFile.getCreationTime();
        String rootHash = dFile.getThexRootHash();
        if (rootHash != null) {
            String xjbLowestLevelNodes = dFile.getThexLowestLevelNodes();
            int depth = dFile.getThexTreeDepth();
            if (this.thexData == null) {
                this.thexData = new ShareFileThexData(rootHash, xjbLowestLevelNodes, depth);
            } else {
                this.thexData.updateFromCache(rootHash, xjbLowestLevelNodes, depth);
            }
        }
        List<DAlternateLocation> list = dFile.getAltLocList();
        for (DAlternateLocation dAltLoc : list) {
            try {
                String hostAddress = dAltLoc.getHostAddress();
                String altLocUrn = dAltLoc.getUrn();
                if (altLocUrn == null) continue;
                DestAddress address = PresentationManager.getInstance().createHostAddress(hostAddress, 6346);
                AlternateLocation altLoc = new AlternateLocation(address, new URN(altLocUrn));
                this.getAltLocContainer().addAlternateLocation(altLoc);
            }
            catch (Exception exp) {
                NLogger.error(ShareFile.class, (Object)"AlternateLocation skipped due to error.", (Throwable)exp);
            }
        }
    }

    public DSharedFile createDSharedFile() {
        DSharedFile dFile = new DSharedFile();
        dFile.setFileName(this.systemFile.getAbsolutePath());
        dFile.setSha1(this.getSha1());
        if (this.thexData != null) {
            dFile.setThexTreeDepth(this.thexData.getTreeDepth());
            dFile.setThexRootHash(this.thexData.getRootHash());
            dFile.setThexLowestLevelNodes(this.thexData.getXJBLowestLevelNodes());
        }
        dFile.setLastModified(this.systemFile.lastModified());
        dFile.setHitCount(this.searchCount);
        dFile.setUploadCount(this.uploadCount);
        dFile.setCreationTime(this.networkCreateTime);
        if (this.alternateLocations != null) {
            this.alternateLocations.createDAlternateLocationList(dFile.getAltLocList());
        }
        return dFile;
    }

    public String toString() {
        return super.toString() + " " + this.getFileName() + "  " + this.fileIndex;
    }
}

