/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.msg.InvalidMessageException;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.prefs.core.MessagePrefs;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.servent.Servent;

public class WhatsNewSearch
extends Search {
    public WhatsNewSearch(boolean isFirewalled, Servent servent) {
        super(servent);
        this.queryMsg = QueryMsg.createWhatsNewQuery(MessagePrefs.TTL.get().byteValue(), isFirewalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(QueryResponseMsg msg) throws InvalidMessageException {
        if (!msg.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        QueryHitHost qhHost = QueryHitHost.createFrom(msg);
        QueryResponseRecord[] records = msg.getMsgRecords();
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(records.length);
        for (int i = 0; i < records.length; ++i) {
            if (!this.isResponseRecordValid(records[i])) continue;
            WhatsNewSearch whatsNewSearch = this;
            synchronized (whatsNewSearch) {
                RemoteFile rfile;
                long fileSize = records[i].getFileSize();
                String filename = records[i].getFilename();
                URN urn = records[i].getURN();
                int fileIndex = records[i].getFileIndex();
                String metaData = records[i].getMetaData();
                RemoteFile availableHit = this.searchResultHolder.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                if (availableHit != null) {
                    availableHit.updateQueryHitHost(qhHost);
                    availableHit.setMetaData(metaData);
                } else {
                    String pathInfo = records[i].getPathInfo();
                    rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, 100);
                    this.searchResultHolder.addQueryHit(rfile);
                    newHitList.add(rfile);
                }
                DestAddress[] alternateLocations = records[i].getAlternateLocations();
                if (urn != null && alternateLocations != null) {
                    for (int j = 0; j < alternateLocations.length; ++j) {
                        QueryHitHost qhh = new QueryHitHost(null, alternateLocations[j], -1);
                        availableHit = this.searchResultHolder.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                        if (availableHit != null) {
                            availableHit.updateQueryHitHost(qhHost);
                            availableHit.setMetaData(metaData);
                            continue;
                        }
                        rfile = new RemoteFile(qhh, -1, filename, "", fileSize, urn, metaData, 100);
                        this.searchResultHolder.addQueryHit(rfile);
                        newHitList.add(rfile);
                    }
                }
                continue;
            }
        }
        if (newHitList.size() > 0) {
            if (this.queryEngine != null) {
                this.queryEngine.incrementResultCount(msg.getUniqueResultCount());
            }
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    public String toString() {
        return "[WhatsNewSearch,@" + Integer.toHexString(this.hashCode()) + "]";
    }
}

