/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs.core;

import java.io.File;
import phex.prefs.api.PreferencesFactory;
import phex.prefs.api.Setting;
import phex.prefs.core.PhexCorePrefs;
import phex.utils.SystemProperties;

public class DownloadPrefs
extends PhexCorePrefs {
    public static final Setting<String> DestinationDirectory;
    public static final Setting<String> IncompleteDirectory;
    public static final Setting<Integer> MaxWorkerPerDownload;
    public static final Setting<Integer> MaxTotalDownloadWorker;
    public static final Setting<Integer> MaxWriteBufferPerDownload;
    public static final Setting<Integer> MaxTotalDownloadWriteBuffer;
    public static final Setting<Integer> MaxDownloadsPerIP;
    public static final Setting<Integer> SegmentInitialSize;
    public static final Setting<Integer> SegmentTransferTargetTime;
    public static final Setting<Integer> SegmentMaximumSize;
    public static final Setting<Integer> SegmentMultiple;
    public static final Setting<Integer> CandidateMinAllowedTransferRate;
    public static final Setting<Integer> CandidateLogBufferSize;
    public static final Setting<Integer> PushRequestTimeout;
    public static final Setting<Boolean> AutoRemoveCompleted;
    public static final Setting<Boolean> AutoReadoutMagmaFiles;
    public static final Setting<Boolean> AutoReadoutMetalinkFiles;
    public static final Setting<Boolean> AutoReadoutRSSFiles;

    static {
        File defaultIncDir = new File(SystemProperties.getPhexConfigRoot(), "incomplete");
        File defaultDownDir = new File(SystemProperties.getPhexConfigRoot(), "download");
        DestinationDirectory = PreferencesFactory.createStringSetting("Download.DestinationDirectory", defaultDownDir.getAbsolutePath(), instance);
        IncompleteDirectory = PreferencesFactory.createStringSetting("Download.IncompleteDirectory", defaultIncDir.getAbsolutePath(), instance);
        MaxWorkerPerDownload = PreferencesFactory.createIntRangeSetting("Download.MaxWorkerPerDownload", 4, 1, 99, instance);
        MaxTotalDownloadWorker = PreferencesFactory.createIntRangeSetting("Download.MaxTotalDownloadWorker", 6, 1, 99, instance);
        MaxWriteBufferPerDownload = PreferencesFactory.createIntRangeSetting("Download.MaxWriteBufferPerDownload", 262144, 0, Integer.MAX_VALUE, instance);
        MaxTotalDownloadWriteBuffer = PreferencesFactory.createIntRangeSetting("Download.MaxTotalDownloadWriteBuffer", 0x100000, 0, Integer.MAX_VALUE, instance);
        MaxDownloadsPerIP = PreferencesFactory.createIntRangeSetting("Download.MaxDownloadsPerIP", 1, 1, 99, instance);
        SegmentInitialSize = PreferencesFactory.createIntRangeSetting("Download.SegmentInitialSize", 16384, 1024, 0xA00000, instance);
        SegmentTransferTargetTime = PreferencesFactory.createIntRangeSetting("Download.SegmentTransferTargetTime", 360, 15, 999, instance);
        SegmentMaximumSize = PreferencesFactory.createIntSetting("Download.SegmentMaximumSize", 0xA00000, instance);
        SegmentMultiple = PreferencesFactory.createIntSetting("Download.SegmentMultiple", 4096, instance);
        CandidateMinAllowedTransferRate = PreferencesFactory.createIntRangeSetting("Download.CandidateMinAllowedTransferRate", 1, 1, 102400, instance);
        CandidateLogBufferSize = PreferencesFactory.createIntSetting("Download.CandidateLogBufferSize", 0, instance);
        PushRequestTimeout = PreferencesFactory.createIntSetting("Download.PushRequestTimeout", 30000, instance);
        AutoRemoveCompleted = PreferencesFactory.createBoolSetting("Download.AutoRemoveCompleted", false, instance);
        AutoReadoutMagmaFiles = PreferencesFactory.createBoolSetting("Download.AutoReadoutMagmaFiles", true, instance);
        AutoReadoutMetalinkFiles = PreferencesFactory.createBoolSetting("Download.AutoReadoutMetalinkFiles", true, instance);
        AutoReadoutRSSFiles = PreferencesFactory.createBoolSetting("Download.AutoReadoutRSSFiles", true, instance);
    }
}

