/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import java.util.Arrays;
import phex.io.buffer.ByteBuffer;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.msg.vendor.PushProxyAcknowledgementVMsg;
import phex.msg.vendor.PushProxyRequestVMsg;
import phex.msg.vendor.TCPConnectBackRedirectVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMessageConstants;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public abstract class VendorMsg
extends Message
implements VendorMessageConstants {
    private static final int VM_PREFIX_LENGTH = 8;
    private byte[] vendorId;
    private int subSelector;
    private int version;
    private byte[] data;

    public VendorMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) {
        super(header);
        this.vendorId = vendorId;
        this.subSelector = subSelector;
        this.version = version;
        this.data = data;
    }

    public VendorMsg(byte[] vendorId, int subSelector, int version, byte[] data) {
        super(new MsgHeader(49, 1, 8 + data.length));
        this.vendorId = vendorId;
        this.subSelector = subSelector;
        this.version = version;
        this.data = data;
    }

    public ByteBuffer createMessageBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(8 + this.data.length);
        buffer.put(this.vendorId).putShortLE((short)this.subSelector).putShortLE((short)this.version).put(this.data);
        buffer.rewind();
        return buffer;
    }

    public static VendorMsg parseMessage(MsgHeader header, byte[] aBody) throws InvalidMessageException {
        if (aBody.length < 8) {
            throw new InvalidMessageException("Vendor Message Wrong Format");
        }
        byte[] vendorId = new byte[4];
        System.arraycopy(aBody, 0, vendorId, 0, 4);
        int subSelector = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(aBody, 4));
        int version = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(aBody, 6));
        byte[] data = new byte[aBody.length - 8];
        System.arraycopy(aBody, 8, data, 0, data.length);
        if (subSelector == 0 && Arrays.equals(vendorId, VENDORID_NULL)) {
            return new MessagesSupportedVMsg(header, vendorId, subSelector, version, data);
        }
        if (subSelector == 7) {
            if (Arrays.equals(vendorId, VENDORID_BEAR)) {
                return new TCPConnectBackVMsg(header, vendorId, subSelector, version, data);
            }
            if (Arrays.equals(vendorId, VENDORID_LIME)) {
                return new TCPConnectBackRedirectVMsg(header, vendorId, subSelector, version, data);
            }
        }
        if (subSelector == 4 && Arrays.equals(vendorId, VENDORID_BEAR)) {
            return new HopsFlowVMsg(header, vendorId, subSelector, version, data);
        }
        if (subSelector == 21 && Arrays.equals(vendorId, VENDORID_LIME)) {
            return new PushProxyRequestVMsg(header, vendorId, subSelector, version, data);
        }
        if (subSelector == 22 && Arrays.equals(vendorId, VENDORID_LIME)) {
            return new PushProxyAcknowledgementVMsg(header, vendorId, subSelector, version, data);
        }
        if (subSelector == 10 && Arrays.equals(vendorId, VENDORID_NULL)) {
            return new CapabilitiesVMsg(header, vendorId, subSelector, version, data);
        }
        if (subSelector == 5 && Arrays.equals(vendorId, VENDORID_BEAR)) {
            throw new InvalidMessageException("Unsupported Vendor Message: " + new String(vendorId) + subSelector + "v" + version);
        }
        throw new InvalidMessageException("Unknown Vendor Message variant: " + new String(vendorId) + subSelector + "v" + version);
    }

    public void setVersion(int ver) {
        this.version = ver;
    }

    protected void setVenderMsgData(byte[] data) {
        this.data = data;
        this.getHeader().setDataLength(8 + data.length);
    }

    protected byte[] getVenderMsgData() {
        return this.data;
    }

    public String toString() {
        return "VendorMsg[ VendorId=" + new String(this.vendorId) + ", SubSelector=" + this.subSelector + ", Version=" + this.version + ", DataHEX=[" + HexConverter.toHexString(this.data) + "] ]";
    }
}

