/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.StringTokenizer;
import phex.common.log.NLogger;

public class XQueueParameters {
    private static final int DEFAULT_POLL_MIN = 60000;
    private static final int DEFAULT_POLL_MAX = 120000;
    private int position;
    private int length;
    private int limit;
    private int pollMin;
    private int pollMax;

    public XQueueParameters(int position, int length, int limit, int pollMin, int pollMax) {
        this.position = position;
        this.length = length;
        this.limit = limit;
        this.pollMin = pollMin;
        this.pollMax = pollMax;
    }

    public int getPosition() {
        return this.position;
    }

    public int getRequestSleepTime() {
        int m = this.pollMax / 10;
        int func = m * (this.position - 1) + this.pollMin + 1000;
        return Math.min((this.pollMax + this.pollMin) / 2, func);
    }

    public void update(XQueueParameters updateParameters) {
        if (updateParameters.position != -1) {
            this.position = updateParameters.position;
        }
        if (updateParameters.length != -1) {
            this.length = updateParameters.length;
        }
        if (updateParameters.limit != -1) {
            this.limit = updateParameters.limit;
        }
        if (updateParameters.pollMin != -1) {
            this.pollMin = updateParameters.pollMin;
        }
        if (updateParameters.pollMax != -1) {
            this.pollMax = updateParameters.pollMax;
        }
    }

    public String buildHTTPString() {
        return "position=" + this.position + ",length=" + this.length + ",limit=" + this.limit + ",pollMin=" + this.pollMin + ",pollMax=" + this.pollMax;
    }

    public static XQueueParameters parseXQueueParameters(String httpXQueueValue) {
        StringTokenizer tokenizer = new StringTokenizer(httpXQueueValue, ",");
        int queuePosition = -1;
        int queueLength = -1;
        int queueLimit = -1;
        int queuePollMin = -1;
        int queuePollMax = -1;
        try {
            while (tokenizer.hasMoreTokens()) {
                String lowerCaseToken = tokenizer.nextToken().trim().toLowerCase();
                if (lowerCaseToken.startsWith("position")) {
                    queuePosition = XQueueParameters.parseIntValue(lowerCaseToken);
                    continue;
                }
                if (lowerCaseToken.startsWith("length")) {
                    queueLength = XQueueParameters.parseIntValue(lowerCaseToken);
                    continue;
                }
                if (lowerCaseToken.startsWith("limit")) {
                    queueLimit = XQueueParameters.parseIntValue(lowerCaseToken);
                    continue;
                }
                if (lowerCaseToken.startsWith("pollmin")) {
                    queuePollMin = XQueueParameters.parseIntValue(lowerCaseToken);
                    continue;
                }
                if (!lowerCaseToken.startsWith("pollmax")) continue;
                queuePollMax = XQueueParameters.parseIntValue(lowerCaseToken);
            }
        }
        catch (NumberFormatException exp) {
            NLogger.debug(XQueueParameters.class, (Object)("Invalid X-Queue value: " + httpXQueueValue));
            return null;
        }
        catch (IndexOutOfBoundsException exp) {
            NLogger.debug(XQueueParameters.class, (Object)("Invalid X-Queue value: " + httpXQueueValue));
            return null;
        }
        if (queuePollMin == -1 && queuePollMax == -1) {
            queuePollMin = 60000;
            queuePollMax = 120000;
        } else if (queuePollMin == -1) {
            queuePollMin = Math.min(60000, (queuePollMax *= 1000) / 2);
        } else if (queuePollMax == -1) {
            queuePollMin *= 1000;
            queuePollMin = Math.max(120000, queuePollMin);
        } else {
            queuePollMin *= 1000;
            queuePollMax *= 1000;
        }
        XQueueParameters queueParameters = new XQueueParameters(queuePosition, queueLength, queueLimit, queuePollMin, queuePollMax);
        return queueParameters;
    }

    private static int parseIntValue(String line) {
        int idx = line.indexOf(61);
        String value = line.substring(idx + 1).trim();
        return Integer.parseInt(value);
    }
}

