/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.TimerTask;
import phex.common.AbstractLifeCycle;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.connection.OutgoingConnectionDispatcher;
import phex.connection.PingWorker;
import phex.host.CaughtHostsContainer;
import phex.host.FavoritesContainer;
import phex.host.Host;
import phex.host.HostStatus;
import phex.host.NetworkHostsContainer;
import phex.msg.PongMsg;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;
import phex.udp.hostcache.UdpHostCacheContainer;

public final class HostManager
extends AbstractLifeCycle {
    private static final int MAX_PARALLEL_CONNECTION_TRIES = 10;
    private final Servent servent;
    private final NetworkHostsContainer networkHostsContainer;
    private final CaughtHostsContainer caughtHostsContainer;
    private final UdpHostCacheContainer udpHostCacheContainer;
    private final FavoritesContainer favoritesContainer;

    public HostManager(Servent servent, boolean useUdpHostCache) {
        this.servent = servent;
        this.networkHostsContainer = new NetworkHostsContainer(servent);
        this.caughtHostsContainer = new CaughtHostsContainer(servent);
        this.udpHostCacheContainer = useUdpHostCache ? new UdpHostCacheContainer(servent) : null;
        this.favoritesContainer = new FavoritesContainer(servent);
    }

    protected void doStart() throws Exception {
        this.networkHostsContainer.start();
        this.caughtHostsContainer.setHostFetchingStrategy(this.servent.getHostFetchingStrategy());
        PingWorker pingWorker = new PingWorker(this.servent);
        pingWorker.start();
        Environment.getInstance().scheduleTimerTask(new HostCheckTimer(), 2000L, 2000L);
    }

    public void doStop() {
        if (this.udpHostCacheContainer != null) {
            this.udpHostCacheContainer.saveCachesToFile();
        }
        this.caughtHostsContainer.saveHostsContainer();
        this.favoritesContainer.saveFavoriteHosts();
    }

    public FavoritesContainer getFavoritesContainer() {
        return this.favoritesContainer;
    }

    public CaughtHostsContainer getCaughtHostsContainer() {
        return this.caughtHostsContainer;
    }

    public UdpHostCacheContainer getUhcContainer() {
        return this.udpHostCacheContainer;
    }

    public NetworkHostsContainer getNetworkHostsContainer() {
        return this.networkHostsContainer;
    }

    public boolean isShieldedLeafNode() {
        return this.networkHostsContainer.isShieldedLeafNode();
    }

    public boolean isUltrapeer() {
        return ConnectionPrefs.AllowToBecomeUP.get() != false && ConnectionPrefs.ForceToBeUltrapeer.get() != false || this.networkHostsContainer.hasLeafConnections();
    }

    public boolean areIncommingSlotsAdvertised() {
        if (this.networkHostsContainer.isShieldedLeafNode()) {
            return false;
        }
        return this.networkHostsContainer.hasUltrapeerSlotsAvailable() || this.networkHostsContainer.hasLeafSlotsAvailable();
    }

    public boolean isAbleToBecomeLeafNode() {
        return !this.servent.isAbleToBecomeUltrapeer() || !this.networkHostsContainer.hasLeafConnections() && !this.networkHostsContainer.hasUltrapeerConnections();
    }

    public void addConnectedHost(Host host) {
        this.networkHostsContainer.addConnectedHost(host);
    }

    public void addNetworkHost(Host host) {
        this.networkHostsContainer.addNetworkHost(host);
    }

    public void addIncomingHost(Host host) {
        this.networkHostsContainer.addIncomingHost(host);
    }

    public void removeNetworkHosts(Host[] hosts) {
        this.networkHostsContainer.removeNetworkHosts(hosts);
    }

    public void removeNetworkHost(Host host) {
        this.networkHostsContainer.removeNetworkHost(host);
    }

    public Host[] getLeafConnections() {
        return this.networkHostsContainer.getLeafConnections();
    }

    public Host[] getUltrapeerConnections() {
        return this.networkHostsContainer.getUltrapeerConnections();
    }

    public boolean catchHosts(PongMsg pongMsg) {
        boolean isNew = this.caughtHostsContainer.catchHosts(pongMsg);
        if (this.udpHostCacheContainer != null) {
            this.udpHostCacheContainer.catchHosts(pongMsg);
        }
        return isNew;
    }

    private class HostCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 2000L;

        private HostCheckTimer() {
        }

        public void run() {
            try {
                this.doAutoConnectCheck();
                HostManager.this.networkHostsContainer.periodicallyCheckHosts();
            }
            catch (Throwable th) {
                NLogger.error(HostManager.class, (Object)th, th);
            }
        }

        public void doAutoConnectCheck() {
            int requiredHostCount;
            int hostCount;
            if (!HostManager.this.servent.getOnlineStatus().isNetworkOnline()) {
                return;
            }
            if (HostManager.this.servent.isAbleToBecomeUltrapeer()) {
                hostCount = HostManager.this.networkHostsContainer.getUltrapeerConnectionCount();
                requiredHostCount = ConnectionPrefs.Up2UpConnections.get();
            } else {
                hostCount = HostManager.this.networkHostsContainer.getUltrapeerConnectionCount();
                requiredHostCount = (Integer)ConnectionPrefs.Leaf2UpConnections.get();
            }
            int missingCount = (requiredHostCount - hostCount) * 4;
            int allHostCount = HostManager.this.networkHostsContainer.getNetworkHostCount();
            int errorHostCount = HostManager.this.networkHostsContainer.getNetworkHostCount(HostStatus.ERROR);
            int totalCount = HostManager.this.networkHostsContainer.getTotalConnectionCount();
            int currentTryCount = Math.max(0, allHostCount - totalCount - errorHostCount);
            int upperLimit = Math.min(10, NetworkPrefs.MaxConcurrentConnectAttempts.get()) - currentTryCount;
            int outConnectCount = Math.min(missingCount - currentTryCount, upperLimit);
            if (outConnectCount > 0) {
                NLogger.debug(HostManager.class, (Object)("Auto-connect to " + outConnectCount + " new hosts."));
                OutgoingConnectionDispatcher.dispatchConnectToNextHosts(outConnectCount, HostManager.this.servent);
            }
        }
    }
}

