/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.gwebcache.GWebCacheContainer;
import phex.host.NetworkHostsContainer;
import phex.servent.Servent;

public class GWebCacheManager {
    private final Servent servent;
    private final GWebCacheContainer gWebCacheContainer;
    private boolean isThreadRequestRunning = false;

    public GWebCacheManager(Servent servent) {
        this.servent = servent;
        this.gWebCacheContainer = new GWebCacheContainer(servent);
    }

    public synchronized void invokeQueryMoreHostsRequest(boolean preferPhex) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryHostsRunner runner = new QueryHostsRunner(preferPhex);
        Environment.getInstance().executeOnThreadPool(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public void invokeUpdateRemoteGWebCache(DestAddress myHostAddress, boolean preferPhex) {
        UpdateGWebCacheRunner runner = new UpdateGWebCacheRunner(myHostAddress, preferPhex);
        Environment.getInstance().executeOnThreadPool(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public synchronized void invokeQueryMoreGWebCachesRequest(boolean preferPhex) {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryGWebCachesRunner runner = new QueryGWebCachesRunner(preferPhex);
        Environment.getInstance().executeOnThreadPool(runner, "GWebCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    public void postManagerInitRoutine() {
        NetworkHostsContainer netCont = this.servent.getHostService().getNetworkHostsContainer();
        Environment.getInstance().scheduleTimerTask(new QueryGWebCacheTimer(netCont), 5000L, 3600000L);
        Environment.getInstance().scheduleTimerTask(new UpdateGWebCacheTimer(netCont), 10000L, 5400000L);
    }

    private final class UpdateGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 5400000L;
        private final NetworkHostsContainer netHostsContainer;

        public UpdateGWebCacheTimer(NetworkHostsContainer netHostsContainer) {
            this.netHostsContainer = netHostsContainer;
        }

        public void run() {
            if (GWebCacheManager.this.servent.getOnlineStatus().isNetworkOnline()) {
                DestAddress localAddress = GWebCacheManager.this.servent.getLocalAddress();
                GWebCacheManager.this.invokeUpdateRemoteGWebCache(localAddress, true);
            }
        }
    }

    private final class QueryGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 3600000L;
        private final NetworkHostsContainer netHostsContainer;

        QueryGWebCacheTimer(NetworkHostsContainer netHostsContainer) {
            this.netHostsContainer = netHostsContainer;
        }

        public void run() {
            try {
                if (GWebCacheManager.this.servent.getOnlineStatus().isNetworkOnline()) {
                    GWebCacheManager.this.invokeQueryMoreHostsRequest(true);
                }
            }
            catch (Throwable th) {
                NLogger.error(GWebCacheManager.class, (Object)th, th);
            }
        }
    }

    private final class QueryHostsRunner
    implements Runnable {
        private boolean preferPhex;

        public QueryHostsRunner(boolean preferPhex) {
            this.preferPhex = preferPhex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GWebCacheManager.this.gWebCacheContainer.queryMoreHosts(this.preferPhex);
            }
            finally {
                GWebCacheManager.this.isThreadRequestRunning = false;
            }
        }
    }

    private final class UpdateGWebCacheRunner
    implements Runnable {
        private final DestAddress myHostAddress;
        private boolean preferPhex;

        private UpdateGWebCacheRunner(DestAddress myHostAddress, boolean preferPhex) {
            this.myHostAddress = myHostAddress;
            this.preferPhex = preferPhex;
        }

        public void run() {
            GWebCacheManager.this.gWebCacheContainer.updateRemoteGWebCache(this.myHostAddress, this.preferPhex);
        }
    }

    private final class QueryGWebCachesRunner
    implements Runnable {
        private boolean preferPhex;

        public QueryGWebCachesRunner(boolean preferPhex) {
            this.preferPhex = preferPhex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                GWebCacheManager.this.gWebCacheContainer.queryMoreGWebCaches(this.preferPhex);
            }
            finally {
                GWebCacheManager.this.isThreadRequestRunning = false;
            }
        }
    }
}

