/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.upload;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import phex.common.address.DestAddress;
import phex.common.log.LogBuffer;
import phex.common.log.LogRecord;
import phex.common.log.NLogger;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.LogBufferDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.upload.UploadFilesTableModel;
import phex.prefs.core.UploadPrefs;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.Localizer;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class UploadTab
extends FWTab {
    private static final String UPLOAD_TABLE_IDENTIFIER = "UploadTable";
    private static final UploadState[] EMPTY_UPLOADSTATE_ARRAY = new UploadState[0];
    private UploadManager uploadManager = GUIRegistry.getInstance().getServent().getUploadService();
    private FWTable uploadTable;
    private JScrollPane uploadTableScrollPane;
    private UploadFilesTableModel uploadModel;
    private JPopupMenu uploadPopup;

    public UploadTab() {
        super(1004, Localizer.getString("Upload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.Tab"), Localizer.getString("TTTUpload"), Localizer.getChar("UploadMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("UploadAccelerator")), 3);
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel banner = new FWElegantPanel(Localizer.getString("Uploads"), contentPanel);
        tabBuilder.add((Component)banner, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        MouseHandler mouseHandler = new MouseHandler();
        this.uploadModel = new UploadFilesTableModel(this.uploadManager);
        this.uploadTable = new FWTable(new FWSortedTableModel(this.uploadModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.uploadTable, UPLOAD_TABLE_IDENTIFIER);
        this.uploadTable.activateAllHeaderActions();
        this.uploadTable.setAutoResizeMode(0);
        this.uploadTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.uploadTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getGuiUpdateTimer().addTable(this.uploadTable);
        this.uploadTableScrollPane = FWTable.createFWTableScrollPane(this.uploadTable);
        this.uploadTableScrollPane.addMouseListener(mouseHandler);
        contentBuilder.add((Component)this.uploadTableScrollPane, cc.xy(1, 1));
        GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        FWToolBar uploadToolbar = new FWToolBar(0);
        uploadToolbar.setBorderPainted(false);
        uploadToolbar.setFloatable(false);
        contentBuilder.add((Component)uploadToolbar, cc.xy(1, 3));
        this.uploadPopup = new JPopupMenu();
        FWAction action = new AbortUploadAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        action = new RemoveUploadAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        action = new ViewBitziTicketAction();
        this.addTabAction(action);
        this.uploadPopup.add(action);
        uploadToolbar.addSeparator();
        this.uploadPopup.addSeparator();
        action = new AddToFavoritesAction();
        this.addTabAction(action);
        this.uploadPopup.add(action);
        action = new BrowseHostAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        action = new ChatToHostAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu bhActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.uploadPopup.add(bhActionMenu.menu);
        this.addTabActions(bhActionMenu.actions);
        action = BanHostActionUtils.createToolBarAction(banHostActionProvider);
        uploadToolbar.addAction(action);
        this.addTabAction(action);
        uploadToolbar.addSeparator();
        this.uploadPopup.addSeparator();
        action = new ClearUploadsAction();
        this.addTabAction(action);
        uploadToolbar.addAction(action);
        this.uploadPopup.add(action);
        if (UploadPrefs.UploadStateLogBufferSize.get() > 0) {
            action = new UploadStateLogAction();
            this.addTabAction(action);
            uploadToolbar.addAction(action);
            this.uploadPopup.add(action);
        }
        GUIRegistry.getInstance().getGuiUpdateTimer().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UploadTab.this.refreshTabActions();
            }
        });
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.uploadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.uploadTable);
        }
        if (this.uploadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.uploadTableScrollPane);
        }
    }

    private UploadState[] getSelectedUploadStates() {
        int[] viewRows = this.uploadTable.getSelectedRows();
        if (viewRows.length == 0) {
            return EMPTY_UPLOADSTATE_ARRAY;
        }
        int[] modelRows = this.uploadTable.convertRowIndicesToModel(viewRows);
        UploadState[] states = this.uploadManager.getUploadStatesAt(modelRows);
        return states;
    }

    private UploadState getSelectedUploadState() {
        int viewRow = this.uploadTable.getSelectedRow();
        int modelRow = this.uploadTable.translateRowIndexToModel(viewRow);
        UploadState state = this.uploadManager.getUploadStateAt(modelRow);
        return state;
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTable dTable = GUIUtils.createDTable(this.uploadTable, UPLOAD_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == UploadTab.this.uploadTable || source == UploadTab.this.uploadTableScrollPane) {
                UploadTab.this.uploadPopup.show(source, x, y);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                UploadTab.this.refreshTabActions();
            }
        }
    }

    private class UploadStateLogAction
    extends FWAction {
        public UploadStateLogAction() {
            super(Localizer.getString("UploadTab_ViewLog"), null, Localizer.getString("UploadTab_TTTViewLog"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UploadState uploadState = UploadTab.this.getSelectedUploadState();
                LogBuffer buffer = UploadTab.this.uploadManager.getUploadStateLogBuffer();
                Collection<LogRecord> logRecords = buffer.getLogRecords(uploadState);
                if (logRecords != null) {
                    LogBufferDialog dialog = new LogBufferDialog(logRecords);
                    dialog.setVisible(true);
                }
            }
            catch (Throwable th) {
                NLogger.error(UploadStateLogAction.class, (Object)th, th);
            }
        }

        public void refreshActionState() {
            UploadState uploadState;
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1 && (uploadState = UploadTab.this.getSelectedUploadState()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    class ClearUploadsAction
    extends FWAction {
        ClearUploadsAction() {
            super(Localizer.getString("ClearCompleted"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.Trash"), Localizer.getString("TTTClearCompleted"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadTab.this.uploadManager.cleanUploadStateList();
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState state = UploadTab.this.getSelectedUploadState();
            if (state == null) {
                return;
            }
            GUIActionPerformer.browseHost(state.getHostAddress());
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.ViewBitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            block3: {
                UploadState state = UploadTab.this.getSelectedUploadState();
                if (state == null) {
                    return;
                }
                String url = URLUtil.buildBitziLookupURL(state.getFileURN());
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException exp) {
                    NLogger.warn(ViewBitziTicketAction.class, (Object)exp, (Throwable)exp);
                    Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int choice = JOptionPane.showOptionDialog(UploadTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                    if (choice != 0) break block3;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                }
            }
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            DestAddress[] addresses = new DestAddress[states.length];
            for (int i = 0; i < states.length; ++i) {
                addresses[i] = states[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(addresses);
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            DestAddress[] addresses = new DestAddress[states.length];
            for (int i = 0; i < states.length; ++i) {
                addresses[i] = states[i].getHostAddress();
            }
            return addresses;
        }

        public boolean isBanHostActionEnabled(boolean allowMultipleAddresses) {
            return UploadTab.this.uploadTable.getSelectedRow() >= 0 && (allowMultipleAddresses || UploadTab.this.uploadTable.getSelectedRowCount() <= 1);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState state = UploadTab.this.getSelectedUploadState();
            if (state == null) {
                return;
            }
            GUIActionPerformer.chatToHost(state.getHostAddress());
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class RemoveUploadAction
    extends FWAction {
        RemoveUploadAction() {
            super(Localizer.getString("RemoveUpload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.Remove"), Localizer.getString("TTTRemoveUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == null) continue;
                UploadTab.this.uploadManager.removeUploadState(states[i]);
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            if (UploadTab.this.uploadTable.getRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class AbortUploadAction
    extends FWAction {
        AbortUploadAction() {
            super(Localizer.getString("AbortUpload"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Upload.Stop"), Localizer.getString("TTTAbortUpload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == null || !states[i].isUploadRunning()) continue;
                states[i].stopUpload();
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            UploadState[] states = UploadTab.this.getSelectedUploadStates();
            boolean state = false;
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == null || !states[i].isUploadRunning()) continue;
                state = true;
                break;
            }
            this.setEnabled(state);
        }
    }
}

