/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.cp;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import phex.common.log.NLogger;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchVisualizer;
import phex.gui.tabs.search.cp.SearchControlPanel;
import phex.query.Search;
import phex.utils.Localizer;

public class SearchInfoBox
extends BoxPanel {
    private final UpdateDisplayActionListener updateDisplayListener;
    private SearchControlPanel controlPanel;
    private SearchResultsDataModel displayedDataModel;
    private JLabel searchStatusLbl;
    private JProgressBar progressBar;
    private JLabel totalResultsLbl;
    private JLabel displayedResultsLbl;
    private JLabel filteredResultsLbl;

    public SearchInfoBox(SearchControlPanel cp) {
        super(Localizer.getString("SearchTab_Information"));
        this.controlPanel = cp;
        CellConstraints cc = new CellConstraints();
        FormLayout boxLayout = new FormLayout("6dlu, d, 2dlu, fill:p:grow, 6dlu", "4dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu,p, 2dlu, p, 2dlu, p, 2dlu, p, 6dlu");
        PanelBuilder searchBoxBuilder = new PanelBuilder(boxLayout, this.getContentPanel());
        JLabel label = searchBoxBuilder.addLabel(Localizer.getString("SearchTab_Status"), cc.xy(2, 2));
        label.setToolTipText(Localizer.getString("SearchTab_TTTStatus"));
        this.searchStatusLbl = new JLabel();
        searchBoxBuilder.add((Component)this.searchStatusLbl, cc.xy(4, 2));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setToolTipText(Localizer.getString("SearchTab_TTTProgress"));
        this.progressBar.setStringPainted(true);
        searchBoxBuilder.add((Component)this.progressBar, cc.xywh(2, 4, 3, 1));
        label = searchBoxBuilder.addLabel(Localizer.getString("SearchTab_TotalResults"), cc.xy(2, 6));
        label.setToolTipText(Localizer.getString("SearchTab_TTTTotalResults"));
        this.totalResultsLbl = new JLabel();
        searchBoxBuilder.add((Component)this.totalResultsLbl, cc.xy(4, 6));
        label = searchBoxBuilder.addLabel(Localizer.getString("SearchTab_DisplayedResults"), cc.xy(2, 8));
        label.setToolTipText(Localizer.getString("SearchTab_TTTDisplayedResults"));
        this.displayedResultsLbl = new JLabel();
        searchBoxBuilder.add((Component)this.displayedResultsLbl, cc.xy(4, 8));
        label = searchBoxBuilder.addLabel(Localizer.getString("SearchTab_FilteredResults"), cc.xy(2, 10));
        label.setToolTipText(Localizer.getString("SearchTab_TTTFilteredResults"));
        this.filteredResultsLbl = new JLabel();
        searchBoxBuilder.add((Component)this.filteredResultsLbl, cc.xy(4, 10));
        this.updateDisplayListener = new UpdateDisplayActionListener();
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        GUIRegistry.getInstance().getGuiUpdateTimer().removeActionListener(this.updateDisplayListener);
        this.displayedDataModel = searchResultsDataModel;
        if (this.displayedDataModel != null) {
            GUIRegistry.getInstance().getGuiUpdateTimer().addActionListener(this.updateDisplayListener);
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        if (this.displayedDataModel != null) {
            Search search = this.displayedDataModel.getSearch();
            this.searchStatusLbl.setText(SearchVisualizer.visualizeSearchStatus(search));
            int total = this.displayedDataModel.getAllSearchResultCount();
            int filtered = this.displayedDataModel.getFilteredElementCount();
            this.progressBar.setValue(search.getProgress());
            this.totalResultsLbl.setText(String.valueOf(total));
            this.displayedResultsLbl.setText(String.valueOf(total - filtered));
            this.filteredResultsLbl.setText(String.valueOf(filtered));
        } else {
            this.searchStatusLbl.setText("");
            this.progressBar.setValue(0);
            this.totalResultsLbl.setText("");
            this.displayedResultsLbl.setText("");
            this.filteredResultsLbl.setText("");
        }
    }

    private final class UpdateDisplayActionListener
    implements ActionListener {
        private UpdateDisplayActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SearchInfoBox.this.updateDisplay();
            }
            catch (Throwable th) {
                NLogger.error(SearchInfoBox.class, (Object)th, th);
            }
        }
    }
}

