/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import phex.gui.common.GUIUtils;
import phex.gui.common.PhexColors;
import phex.gui.common.table.FWTable;
import phex.host.Host;
import phex.host.HostStatus;
import phex.host.NetworkHostsContainer;

public class NetworkRowRenderer
implements TableCellRenderer {
    private static final Color FAILED_COLOR = Color.gray;
    private NetworkHostsContainer hostsContainer;
    private Color connectingColor;
    private Color selectionConnectingColor;
    private Color connectedColor;
    private Color selectionConnectedColor;

    public NetworkRowRenderer(NetworkHostsContainer hostsContainer) {
        this.hostsContainer = hostsContainer;
    }

    public void updateUI() {
        this.connectingColor = null;
        this.selectionConnectingColor = null;
        this.connectedColor = null;
        this.selectionConnectedColor = null;
    }

    private Color getForegroundColorForStatus(HostStatus status, JTable table, boolean isSelected) {
        switch (status) {
            case NOT_CONNECTED: {
                return null;
            }
            case ERROR: 
            case DISCONNECTED: {
                return FAILED_COLOR;
            }
            case CONNECTING: 
            case ACCEPTING: {
                if (isSelected) {
                    this.selectionConnectingColor = this.determineColor(this.selectionConnectingColor, PhexColors.NETWORK_HOST_CONNECTING_COLORS, table, isSelected);
                    return this.selectionConnectingColor;
                }
                this.connectingColor = this.determineColor(this.connectingColor, PhexColors.NETWORK_HOST_CONNECTING_COLORS, table, isSelected);
                return this.connectingColor;
            }
            case CONNECTED: {
                if (isSelected) {
                    this.selectionConnectedColor = this.determineColor(this.selectionConnectedColor, PhexColors.NETWORK_HOST_CONNECTED_COLORS, table, isSelected);
                    return this.selectionConnectedColor;
                }
                this.connectedColor = this.determineColor(this.connectedColor, PhexColors.NETWORK_HOST_CONNECTED_COLORS, table, isSelected);
                return this.connectedColor;
            }
        }
        return null;
    }

    private Color determineColor(Color cache, Color[] candidates, JTable table, boolean isSelected) {
        if (cache != null) {
            return cache;
        }
        Color base = isSelected ? table.getSelectionBackground() : table.getBackground();
        return GUIUtils.getBestColorMatch(base, candidates);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(table instanceof FWTable)) {
            throw new IllegalArgumentException("table not of type FWTable");
        }
        TableCellRenderer renderer = table.getDefaultRenderer(table.getColumnClass(column));
        Component comp = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        FWTable fwTable = (FWTable)table;
        if (isSelected) {
            comp.setForeground(table.getSelectionForeground());
        } else {
            comp.setForeground(table.getForeground());
        }
        if (row < this.hostsContainer.getNetworkHostCount()) {
            int modelRow = fwTable.translateRowIndexToModel(row);
            Host host = this.hostsContainer.getNetworkHostAt(modelRow);
            if (host == null) {
                return comp;
            }
            Color col = this.getForegroundColorForStatus(host.getStatus(), fwTable, isSelected);
            if (col != null) {
                comp.setForeground(col);
            }
        }
        return comp;
    }
}

