/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.FileDialogHandler;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.library.LibraryNode;
import phex.gui.tabs.library.SharingTreeModel;
import phex.gui.tabs.library.SharingTreeRenderer;
import phex.prefs.core.LibraryPrefs;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;
import phex.utils.SystemShellExecute;

public class LibraryTreePane
extends JPanel {
    private Component parent;
    private SharingTreeModel sharingTreeModel;
    private JTree mainTree;
    private FWPopupMenu fileTreePopup;
    private AddShareFolderAction addShareFolderAction;
    private RemoveShareFolderAction removeShareFolderAction;
    private ExploreFolderAction exploreFolderAction;

    public LibraryTreePane(Component parent) {
        this.parent = parent;
        this.prepareComponent();
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.mainTree.getSelectionModel().addTreeSelectionListener(listener);
    }

    public void appendPopupSeparator() {
        this.fileTreePopup.addSeparator();
    }

    public void appendPopupAction(FWAction action) {
        this.fileTreePopup.addAction(action);
    }

    public LibraryNode getSelectedTreeComponent() {
        TreePath path = this.mainTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        LibraryNode node = (LibraryNode)path.getLastPathComponent();
        return node;
    }

    public void updateFileSystem() {
        this.sharingTreeModel.updateFileSystem();
    }

    private void refreshActions() {
        this.addShareFolderAction.refreshActionState();
        this.removeShareFolderAction.refreshActionState();
        if (this.exploreFolderAction != null) {
            this.exploreFolderAction.refreshActionState();
        }
    }

    private void prepareComponent() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder tabBuilder = new PanelBuilder(layout, this);
        this.sharingTreeModel = new SharingTreeModel();
        this.mainTree = new JTree(this.sharingTreeModel);
        this.mainTree.setMinimumSize(new Dimension(0, 0));
        this.mainTree.setRowHeight(0);
        this.mainTree.setCellRenderer(new SharingTreeRenderer());
        this.mainTree.addMouseListener(new MouseHandler());
        this.mainTree.getSelectionModel().addTreeSelectionListener(new SelectionHandler());
        ToolTipManager.sharedInstance().registerComponent(this.mainTree);
        TreeNode root = (TreeNode)this.sharingTreeModel.getRoot();
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mainTree.expandPath(new TreePath(new Object[]{root, root.getChildAt(i)}));
        }
        JScrollPane treeScrollPane = new JScrollPane(this.mainTree);
        tabBuilder.add((Component)treeScrollPane, cc.xywh(1, 1, 1, 1));
        FWToolBar shareToolbar = new FWToolBar(0);
        shareToolbar.setBorderPainted(false);
        shareToolbar.setFloatable(false);
        tabBuilder.add((Component)shareToolbar, cc.xy(1, 3));
        this.addShareFolderAction = new AddShareFolderAction();
        shareToolbar.addAction(this.addShareFolderAction);
        this.removeShareFolderAction = new RemoveShareFolderAction();
        shareToolbar.addAction(this.removeShareFolderAction);
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            this.exploreFolderAction = new ExploreFolderAction();
        }
        this.fileTreePopup = new FWPopupMenu();
        this.fileTreePopup.addAction(this.addShareFolderAction);
        this.fileTreePopup.addAction(this.removeShareFolderAction);
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX) {
            this.fileTreePopup.addAction(this.exploreFolderAction);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            LibraryTreePane.this.refreshActions();
            LibraryTreePane.this.fileTreePopup.show(source, x, y);
        }
    }

    private class SelectionHandler
    implements TreeSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            final Object treeRoot = LibraryTreePane.this.sharingTreeModel.getRoot();
            Object lastPathComponent = e.getPath().getLastPathComponent();
            if (lastPathComponent == treeRoot) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Object[] path = new Object[]{treeRoot, LibraryTreePane.this.sharingTreeModel.getChild(treeRoot, 0)};
                        LibraryTreePane.this.mainTree.setSelectionPath(new TreePath(path));
                    }
                });
                return;
            }
            LibraryTreePane.this.refreshActions();
        }
    }

    private class ExploreFolderAction
    extends FWAction {
        ExploreFolderAction() {
            super(Localizer.getString("LibraryTab_Explore"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.Explore"), Localizer.getString("LibraryTab_TTTExplore"));
        }

        public void actionPerformed(ActionEvent e) {
            TreePath selectionPath = LibraryTreePane.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                return;
            }
            File dir = ((LibraryNode)lastPathComponent).getSystemFile();
            if (dir == null) {
                return;
            }
            try {
                SystemShellExecute.exploreFolder(dir);
            }
            catch (IOException exp) {
                // empty catch block
            }
        }

        public void refreshActionState() {
            TreePath selectionPath = LibraryTreePane.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                this.setEnabled(false);
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                this.setEnabled(false);
                return;
            }
            File file = ((LibraryNode)lastPathComponent).getSystemFile();
            if (file == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    private class RemoveShareFolderAction
    extends FWAction {
        RemoveShareFolderAction() {
            super(Localizer.getString("LibraryTab_StopShare"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.ShareFolderClear"), Localizer.getString("LibraryTab_TTTStopShare"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            TreePath selectionPath = LibraryTreePane.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                return;
            }
            final File file = ((LibraryNode)lastPathComponent).getSystemFile();
            if (file == null) {
                return;
            }
            Runnable runner = new Runnable(){

                public void run() {
                    RemoveShareFolderAction.this.stopShareDirRecursive(file);
                    GUIActionPerformer.rescanSharedFiles();
                }
            };
            Environment.getInstance().executeOnThreadPool(runner, "RemoveShareFolderAction");
            this.refreshActionState();
        }

        private void stopShareDirRecursive(File file) {
            if (!file.isDirectory()) {
                return;
            }
            LibraryPrefs.SharedDirectoriesSet.get().remove(file.getAbsolutePath());
            LibraryPrefs.SharedDirectoriesSet.changed();
            SharedFilesService sharedFilesService = GUIRegistry.getInstance().getServent().getSharedFilesService();
            SharedDirectory directory = sharedFilesService.getSharedDirectory(file);
            if (directory == null) {
                return;
            }
            File[] dirs = file.listFiles(new DirectoryOnlyFileFilter());
            for (int i = 0; i < dirs.length; ++i) {
                this.stopShareDirRecursive(dirs[i]);
            }
        }

        public void refreshActionState() {
            TreePath selectionPath = LibraryTreePane.this.mainTree.getSelectionPath();
            if (selectionPath == null) {
                this.setEnabled(false);
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof LibraryNode)) {
                this.setEnabled(false);
                return;
            }
            File file = ((LibraryNode)lastPathComponent).getSystemFile();
            if (file == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    private class AddShareFolderAction
    extends FWAction {
        AddShareFolderAction() {
            super(Localizer.getString("LibraryTab_Share"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.ShareFolder"), Localizer.getString("LibraryTab_TTTShare"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File[] files;
                Object lastPathComponent;
                File currentDirectory = null;
                TreePath selectionPath = LibraryTreePane.this.mainTree.getSelectionPath();
                if (selectionPath != null && (lastPathComponent = selectionPath.getLastPathComponent()) instanceof LibraryNode) {
                    currentDirectory = ((LibraryNode)lastPathComponent).getSystemFile();
                }
                if ((files = FileDialogHandler.openMultipleDirectoryChooser(LibraryTreePane.this.parent, Localizer.getString("LibraryTab_SelectDirectoryToShare"), Localizer.getString("LibraryTab_Select"), Localizer.getChar("LibraryTab_SelectMnemonic"), currentDirectory, Localizer.getString("LibraryTab_CopyrightWarnTitle"), Localizer.getString("LibraryTab_CopyrightWarnMessage"))) == null) {
                    return;
                }
                Runnable runner = new Runnable(){

                    public void run() {
                        try {
                            for (int i = 0; i < files.length; ++i) {
                                if (files[i] == null) continue;
                                AddShareFolderAction.this.shareDirRecursive(files[i]);
                            }
                            GUIActionPerformer.rescanSharedFiles();
                        }
                        catch (Throwable th) {
                            NLogger.error(LibraryTreePane.class, (Object)th, th);
                        }
                    }
                };
                Environment.getInstance().executeOnThreadPool(runner, "AddShareFolderAction");
            }
            catch (Throwable th) {
                NLogger.error(LibraryTreePane.class, (Object)th, th);
            }
        }

        public void refreshActionState() {
        }

        private void shareDirRecursive(File file) {
            if (!file.isDirectory()) {
                return;
            }
            LibraryPrefs.SharedDirectoriesSet.get().add(file.getAbsolutePath());
            LibraryPrefs.SharedDirectoriesSet.changed();
            File[] dirs = file.listFiles(new DirectoryOnlyFileFilter());
            if (dirs == null) {
                return;
            }
            for (int i = 0; i < dirs.length; ++i) {
                this.shareDirRecursive(dirs[i]);
            }
        }
    }
}

