/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.wizard.consequence;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import phex.common.log.NLogger;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.gui.dialogs.filter.wizard.consequence.ConsequenceCellRenderer;
import phex.gui.dialogs.filter.wizard.consequence.ConsequenceTableModel;
import phex.rules.Rule;
import phex.rules.consequence.Consequence;
import phex.utils.Localizer;

public class ConsequencePanel
extends JPanel {
    private FilterWizardDialog parent;
    private ConsequenceTableModel consequenceTableModel;
    private FWTable consequenceTable;
    private JLabel selectConsequenceLbl;

    public ConsequencePanel(FilterWizardDialog parent) {
        this.parent = parent;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "p, 2dlu, fill:75dlu:grow");
        PanelBuilder contentPB = new PanelBuilder(layout, this);
        this.selectConsequenceLbl = new JLabel(Localizer.getString("RuleWizard_SelectRuleConsequence"));
        contentPB.add((Component)this.selectConsequenceLbl, cc.xywh(1, 1, 1, 1));
        this.consequenceTableModel = new ConsequenceTableModel(this);
        this.consequenceTable = new FWTable(this.consequenceTableModel);
        this.consequenceTable.setShowVerticalLines(false);
        JTableHeader tableHeader = this.consequenceTable.getTableHeader();
        tableHeader.setResizingAllowed(false);
        tableHeader.setReorderingAllowed(false);
        JCheckBox box = (JCheckBox)((Object)this.consequenceTable.getDefaultRenderer(Boolean.class));
        TableColumn column = this.consequenceTable.getColumnModel().getColumn(0);
        column.setMaxWidth(box.getPreferredSize().width + 2);
        column.setMinWidth(box.getPreferredSize().width + 2);
        this.consequenceTable.getColumnModel().getColumn(1).setCellRenderer(new ConsequenceCellRenderer());
        contentPB.add((Component)FWTable.createFWTableScrollPane(this.consequenceTable), cc.xywh(1, 3, 1, 1));
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        int rowCount = this.consequenceTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.consequenceTableModel.consequences[i][0] = Boolean.FALSE;
        }
        List<Consequence> consequencesList = rule.getConsequences();
        for (Consequence consequence : consequencesList) {
            int row = this.consequenceTableModel.getRowOf(consequence);
            this.consequenceTableModel.consequences[row][0] = Boolean.TRUE;
        }
        this.consequenceTable.setEnabled(!rule.isDefaultRule());
        this.selectConsequenceLbl.setEnabled(!rule.isDefaultRule());
        this.consequenceTableModel.fireTableDataChanged();
    }

    public void ruleStatusChanged(Class consequenceClass, boolean status) {
        Rule editRule = this.parent.getEditRule();
        if (status) {
            try {
                Consequence newConsequence = (Consequence)consequenceClass.newInstance();
                editRule.addConsequence(newConsequence);
                this.parent.updateRuleData();
            }
            catch (InstantiationException exp) {
                NLogger.error(ConsequencePanel.class, (Object)exp, (Throwable)exp);
            }
            catch (IllegalAccessException exp) {
                NLogger.error(ConsequencePanel.class, (Object)exp, (Throwable)exp);
            }
        } else {
            List<Consequence> consequences = editRule.getConsequences();
            for (int i = consequences.size() - 1; i >= 0; --i) {
                Consequence consequence = consequences.get(i);
                if (consequence.getClass() != consequenceClass) continue;
                editRule.removeConsequence(consequence);
            }
            this.parent.updateRuleData();
        }
    }
}

