/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.configwizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phex.gui.common.GUIUtils;
import phex.gui.common.HTMLMultiLinePanel;
import phex.gui.dialogs.configwizard.ConfigurationWizardDialog;
import phex.prefs.core.DownloadPrefs;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.FileUtils;
import phex.utils.Localizer;

public class DirectoryPanel
extends JPanel {
    private ConfigurationWizardDialog parent;
    private JTextField incompleteDirectoryTF;
    private JTextField downloadDirectoryTF;

    public DirectoryPanel(ConfigurationWizardDialog parent) {
        this.parent = parent;
        this.prepareComponent();
    }

    private void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, d:grow, 2dlu, d, right:d:grow", "p, 3dlu, p, 8dlu, p, 3dlu, p, 8dlu, p");
        this.setLayout(layout);
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(layout, this);
        int columnCount = layout.getColumnCount();
        builder.addSeparator(Localizer.getString("ConfigWizard_DirectoryHeader"), cc.xywh(1, 1, columnCount, 1));
        HTMLMultiLinePanel welcomeLines = new HTMLMultiLinePanel(Localizer.getString("ConfigWizard_DirectoryText"));
        builder.add((Component)welcomeLines, cc.xywh(2, 3, columnCount - 2, 1));
        builder.addLabel(Localizer.getString("ConfigWizard_Incomplete"), cc.xy(2, 5));
        this.incompleteDirectoryTF = new JTextField(DownloadPrefs.IncompleteDirectory.get(), 30);
        builder.add((Component)this.incompleteDirectoryTF, cc.xy(4, 5));
        JButton button = new JButton(Localizer.getString("ConfigWizard_SetFolder"));
        button.addActionListener(new SetIncompleteDirectoryListener());
        builder.add((Component)button, cc.xy(6, 5));
        builder.addLabel(Localizer.getString("ConfigWizard_Destination"), cc.xy(2, 7));
        this.downloadDirectoryTF = new JTextField(DownloadPrefs.DestinationDirectory.get(), 30);
        builder.add((Component)this.downloadDirectoryTF, cc.xy(4, 7));
        button = new JButton(Localizer.getString("ConfigWizard_SetFolder"));
        button.addActionListener(new SetDownloadDirectoryListener());
        builder.add((Component)button, cc.xy(6, 7));
        HTMLMultiLinePanel welcomeLines2 = new HTMLMultiLinePanel(Localizer.getString("ConfigWizard_DirectoryText2"));
        builder.add((Component)welcomeLines2, cc.xywh(2, 9, columnCount - 2, 1));
    }

    public boolean checkInput() {
        String downloadDirPath = this.downloadDirectoryTF.getText();
        File downloadDir = new File(downloadDirPath);
        String incompleteDirPath = this.incompleteDirectoryTF.getText();
        File incompleteDir = new File(incompleteDirPath);
        if (!downloadDir.exists() || !downloadDir.isDirectory()) {
            try {
                FileUtils.forceMkdir(downloadDir);
            }
            catch (IOException exp) {
                this.downloadDirectoryTF.requestFocus();
                this.downloadDirectoryTF.selectAll();
                GUIUtils.showErrorMessage(Localizer.getFormatedString("CantCreateDownloadDir", this.downloadDirectoryTF.getText()), Localizer.getString("DirectoryError"));
                return false;
            }
        }
        if (!incompleteDir.exists() || !incompleteDir.isDirectory()) {
            try {
                FileUtils.forceMkdir(incompleteDir);
            }
            catch (IOException exp) {
                this.incompleteDirectoryTF.requestFocus();
                this.incompleteDirectoryTF.selectAll();
                GUIUtils.showErrorMessage(Localizer.getFormatedString("CantCreateIncompleteDir", this.incompleteDirectoryTF.getText()), Localizer.getString("DirectoryError"));
                return false;
            }
        }
        return true;
    }

    public void saveSettings() {
        String downloadDirPath = this.downloadDirectoryTF.getText();
        File downloadDir = new File(downloadDirPath);
        downloadDirPath = downloadDir.getAbsolutePath();
        DownloadPrefs.DestinationDirectory.set(downloadDirPath);
        String incompleteDirPath = this.incompleteDirectoryTF.getText();
        File incompleteDir = new File(incompleteDirPath);
        incompleteDirPath = incompleteDir.getAbsolutePath();
        DownloadPrefs.IncompleteDirectory.set(incompleteDirPath);
    }

    private class SetIncompleteDirectoryListener
    implements ActionListener {
        private SetIncompleteDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(DirectoryPanel.this.incompleteDirectoryTF.getText()));
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new DirectoryOnlyFileFilter());
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Localizer.getString("SelectIncompleteDirectory"));
            chooser.setApproveButtonText(Localizer.getString("Select"));
            chooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int returnVal = chooser.showDialog(DirectoryPanel.this, null);
            if (returnVal == 0) {
                String directory = chooser.getSelectedFile().getAbsolutePath();
                DirectoryPanel.this.incompleteDirectoryTF.setText(directory);
            }
        }
    }

    private class SetDownloadDirectoryListener
    implements ActionListener {
        private SetDownloadDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(DirectoryPanel.this.downloadDirectoryTF.getText()));
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new DirectoryOnlyFileFilter());
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Localizer.getString("SelectDownloadDirectory"));
            chooser.setApproveButtonText(Localizer.getString("Select"));
            chooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int returnVal = chooser.showDialog(DirectoryPanel.this, null);
            if (returnVal == 0) {
                String directory = chooser.getSelectedFile().getAbsolutePath();
                DirectoryPanel.this.downloadDirectoryTF.setText(directory);
            }
        }
    }
}

