/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.HTMLMultiLinePanel;
import phex.utils.Localizer;

public class RespectCopyrightDialog
extends JDialog {
    private HTMLMultiLinePanel textPane;
    private JCheckBox dontShowAgainChkbx;

    public RespectCopyrightDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("RespectCopyrightDialog_DialogTitle"), true);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, 200dlu, 4dlu", "4dlu, p, 4dlu, p, 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        this.textPane = new HTMLMultiLinePanel(Localizer.getString("RespectCopyrightDialog_Text"));
        contentPB.add((Component)this.textPane, cc.xy(2, 2));
        this.dontShowAgainChkbx = new JCheckBox(Localizer.getString("RespectCopyrightDialog_DontShowAgain"));
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(closeEventHandler);
        ButtonBarBuilder btnBarBuilder = new ButtonBarBuilder();
        btnBarBuilder.addGridded(this.dontShowAgainChkbx);
        btnBarBuilder.addRelatedGap();
        btnBarBuilder.addGlue();
        btnBarBuilder.addGriddedButtons(new JButton[]{okBtn});
        contentPB.add((Component)btnBarBuilder.getPanel(), cc.xy(2, 4));
        this.pack();
        this.textPane.getPreferredSize();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        this.setAlwaysOnTop(true);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            this.handleClose();
        }

        public void actionPerformed(ActionEvent e) {
            this.handleClose();
        }

        private void handleClose() {
            boolean isSelected = RespectCopyrightDialog.this.dontShowAgainChkbx.isSelected();
            if (isSelected) {
                GUIRegistry.getInstance().setRespectCopyrightNoticeShown(!isSelected);
            }
            RespectCopyrightDialog.this.closeDialog();
        }
    }
}

