/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import phex.common.log.NLogger;
import phex.gui.actions.FWAction;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;

public class OpenURLAction
extends FWAction {
    private String url;

    public OpenURLAction(String name, String url, Icon smallIcon, String toolTipText, Integer mnemonic, KeyStroke keyStroke) {
        super(name, smallIcon, toolTipText, mnemonic, keyStroke);
        this.url = url;
    }

    public void actionPerformed(ActionEvent e) {
        boolean hasError = false;
        try {
            BrowserLauncher.openURL(this.url);
        }
        catch (UnsatisfiedLinkError error) {
            NLogger.error(OpenURLAction.class, (Object)error, (Throwable)error);
            hasError = true;
        }
        catch (IOException exp) {
            NLogger.warn(OpenURLAction.class, (Object)exp, (Throwable)exp);
            hasError = true;
        }
        if (hasError) {
            int choice;
            Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
            JComponent comp = GUIRegistry.getInstance().getMainFrame().getSelectedTab();
            if (comp == null) {
                comp = GUIRegistry.getInstance().getMainFrame().getRootPane();
            }
            if ((choice = JOptionPane.showOptionDialog(comp, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"))) == 0) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.url), null);
            }
        }
    }

    public void refreshActionState() {
    }
}

