/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.common.TransferDataProvider;
import phex.common.bandwidth.TransferAverage;
import phex.common.log.NLogger;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;

public class SWDownloadSegment
implements TransferDataProvider,
SWDownloadConstants {
    private long start;
    private long length;
    private long transferredDataSize;
    private Integer currentProgress;
    private SWDownloadFile downloadFile;
    private long transferStartTime;
    private long transferStopTime;
    private TransferAverage transferAverage;

    public SWDownloadSegment(SWDownloadFile aDownloadFile, long aStartPos, long aLength) {
        this.start = aStartPos;
        this.length = aLength;
        this.downloadFile = aDownloadFile;
        this.transferredDataSize = 0L;
        this.currentProgress = 0;
        this.transferAverage = new TransferAverage(1000, 6);
    }

    public long getTransferStartPosition() {
        return this.start + this.transferredDataSize;
    }

    public long getEnd() {
        if (this.length == -1L) {
            return -1L;
        }
        return this.start + this.length - 1L;
    }

    public long getStart() {
        return this.start;
    }

    public long getTransferDataSizeLeft() {
        if (this.length == -1L) {
            return -1L;
        }
        return Math.max(0L, this.length - this.transferredDataSize);
    }

    public void setTransferredDataSize(long size) {
        if (size < this.transferredDataSize) {
            throw new IllegalArgumentException("Transfered data size is not allowed to go down!");
        }
        if (this.length > -1L && size > this.length) {
            throw new IllegalArgumentException("Transfered data size is not to grow beyond segments size!");
        }
        long diff = size - this.transferredDataSize;
        this.transferAverage.addValue(diff);
        this.transferredDataSize = size;
    }

    public void downloadStartNotify() {
        this.transferStartTime = System.currentTimeMillis();
        this.transferStopTime = 0L;
    }

    public void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
        }
    }

    public Integer getProgress() {
        long transferDataSize = this.getTransferDataSize();
        int percentage = transferDataSize > 0L ? (int)(this.getTransferredDataSize() * 100L / transferDataSize) : 0;
        if (this.currentProgress != percentage) {
            this.currentProgress = percentage;
        }
        return this.currentProgress;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("[start: ");
        buffer.append(this.start);
        buffer.append(", so far: ");
        buffer.append(this.transferredDataSize);
        buffer.append(" of ");
        buffer.append(this.length);
        buffer.append("]@");
        buffer.append(this.hashCode());
        buffer.append("\n");
        return buffer.toString();
    }

    private void validateTransferredDataSize() {
        if (this.length != -1L && this.transferredDataSize > this.length) {
            NLogger.error(SWDownloadFile.class, (Object)("Transferred data size above transfer data size: " + this.toString()));
        }
    }

    public long getTransferSpeed() {
        if (this.transferStopTime > 0L && this.transferStopTime - this.transferStartTime < 1000L) {
            return this.transferredDataSize;
        }
        return this.transferAverage.getAverage();
    }

    public long getTransferredDataSize() {
        return this.transferredDataSize;
    }

    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    public long getTransferDataSize() {
        return this.length;
    }

    public void setTransferRateTimestamp(long timestamp) {
        throw new UnsupportedOperationException();
    }

    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    public short getDataTransferStatus() {
        if (this.transferStartTime != 0L && this.transferStopTime == 0L) {
            return 10;
        }
        return 11;
    }
}

