/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.common.format.TimeFormatUtils;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.utils.Localizer;

public final class SWDownloadInfo
implements SWDownloadConstants {
    private SWDownloadInfo() {
    }

    public static String getDownloadFileStatusString(int status) {
        switch (status) {
            case 1: {
                return Localizer.getString("WaitingForDownload");
            }
            case 2: {
                return Localizer.getString("Downloading");
            }
            case 3: 
            case 6: {
                return Localizer.getString("Completed");
            }
            case 4: {
                return Localizer.getString("Stopped");
            }
            case 5: {
                return Localizer.getString("FileQueued");
            }
        }
        Object[] arguments = new Object[]{status};
        return Localizer.getFormatedString("UnrecognizedStatus", arguments);
    }

    public static String getDownloadCandidateStatusString(SWDownloadCandidate candidate) {
        SWDownloadCandidate.CandidateStatus status = candidate.getStatus();
        switch (status) {
            case IGNORED: {
                return Localizer.getString("CandidateIgnored") + " (" + Localizer.getString(candidate.getStatusReason()) + ").";
            }
            case BAD: {
                Object[] arguments = new Object[]{candidate.getStatusTimeLeft() / 1000L, TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("CandidateOffline", arguments);
            }
            case WAITING: {
                return Localizer.getString("WaitingForDownload");
            }
            case BUSY: {
                Object[] arguments = new Object[]{candidate.getStatusTimeLeft() / 1000L, TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("HostBusy", arguments);
            }
            case CONNECTING: {
                Object[] arguments = new Object[]{candidate.getStatusTimeLeft() / 1000L};
                return Localizer.getFormatedString("Connecting", arguments);
            }
            case RANGE_UNAVAILABLE: {
                Object[] arguments = new Object[]{TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("RangeUnavailable", arguments);
            }
            case REMOTLY_QUEUED: {
                Object[] arguments = new Object[3];
                arguments[0] = candidate.getXQueueParameters().getPosition();
                arguments[1] = TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L));
                return Localizer.getFormatedString("RemotlyQueued", arguments);
            }
            case CONNECTION_FAILED: {
                Object[] arguments = new Object[]{candidate.getFailedConnectionTries(), candidate.getStatusTimeLeft() / 1000L, TimeFormatUtils.convertSecondsToTime((int)(candidate.getStatusTimeLeft() / 1000L))};
                return Localizer.getFormatedString("ConnectionFailed", arguments);
            }
            case PUSH_REQUEST: {
                Object[] arguments = new Object[]{candidate.getStatusTimeLeft() / 1000L};
                return Localizer.getFormatedString("PushRequest", arguments);
            }
            case REQUESTING: {
                return Localizer.getFormatedString("Requesting", null);
            }
            case DOWNLOADING: {
                return Localizer.getFormatedString("Downloading", null);
            }
        }
        Object[] arguments = new Object[]{status.name()};
        return Localizer.getFormatedString("UnrecognizedStatus", arguments);
    }
}

