/*
 * Decompiled with CFR 0.152.
 */
package phex.download.strategy;

import java.util.Random;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.strategy.AvailabilityScopeSelectionStrategy;
import phex.download.strategy.PrefereBeginingScopeSelectionStrategy;
import phex.download.strategy.RandomScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.swarming.SWDownloadFile;

public class AvailBeginRandSelectionStrategy
implements ScopeSelectionStrategy {
    private final Random random = new Random();
    private final ScopeSelectionStrategy availStrategy;
    private final ScopeSelectionStrategy beginStrategy;
    private final ScopeSelectionStrategy randStrategy;

    protected AvailBeginRandSelectionStrategy(AvailabilityScopeSelectionStrategy availStrategy, PrefereBeginingScopeSelectionStrategy beginStrategy, RandomScopeSelectionStrategy randStrategy) {
        this.availStrategy = availStrategy;
        this.beginStrategy = beginStrategy;
        this.randStrategy = randStrategy;
    }

    public DownloadScope selectDownloadScope(SWDownloadFile downloadFile, DownloadScopeList wantedScopeList, long preferredSize) {
        boolean useBegin;
        DownloadScope scope = this.availStrategy.selectDownloadScope(downloadFile, wantedScopeList, preferredSize);
        if (scope == null && downloadFile.isDestinationStreamable() && (useBegin = this.random.nextBoolean())) {
            scope = this.beginStrategy.selectDownloadScope(downloadFile, wantedScopeList, preferredSize);
        }
        if (scope == null) {
            scope = this.randStrategy.selectDownloadScope(downloadFile, wantedScopeList, preferredSize);
        }
        return scope;
    }
}

