/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.Closeable;
import java.io.IOException;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.log.NLogger;
import phex.connection.ConnectionEngine;
import phex.download.PushHandler;
import phex.event.PhexEventService;
import phex.host.Host;
import phex.host.HostStatus;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.io.buffer.BufferCache;
import phex.msg.GUID;
import phex.net.connection.Connection;
import phex.net.repres.SocketFacade;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;
import phex.share.HttpRequestDispatcher;
import phex.utils.IOUtil;
import phex.utils.URLCodecUtils;

public class IncomingConnectionDispatcher
implements Runnable {
    public static final String GET_REQUEST_PREFIX = "GET ";
    public static final String HEAD_REQUEST_PREFIX = "HEAD ";
    public static final String GIV_REQUEST_PREFIX = "GIV ";
    public static final String CHAT_REQUEST_PREFIX = "CHAT ";
    public static final String URI_DOWNLOAD_PREFIX = "PHEX_URI ";
    public static final String MAGMA_DOWNLOAD_PREFIX = "PHEX_MAGMA ";
    public static final String RSS_DOWNLOAD_PREFIX = "PHEX_RSS ";
    private final Servent servent;
    private final SocketFacade socket;

    public IncomingConnectionDispatcher(SocketFacade socket, Servent servent) {
        this.socket = socket;
        this.servent = servent;
    }

    public void run() {
        block18: {
            Closeable gInStream = null;
            try {
                this.socket.setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
                BandwidthController bwController = this.servent.getBandwidthService().getNetworkBandwidthController();
                Connection connection = new Connection(this.socket, bwController);
                String requestLine = connection.readLine();
                if (requestLine == null) {
                    throw new IOException("Disconnected from remote host during handshake");
                }
                NLogger.debug(IncomingConnectionDispatcher.class, (Object)("ConnectionRequest " + requestLine));
                DestAddress localAddress = this.servent.getLocalAddress();
                String greeting = this.servent.getGnutellaNetwork().getNetworkGreeting();
                if (requestLine.startsWith(greeting + "/")) {
                    if (!this.servent.getOnlineStatus().isNetworkOnline() && !this.socket.getRemoteAddress().isLocalHost(localAddress)) {
                        throw new IOException("Network not connected.");
                    }
                    DestAddress address = this.socket.getRemoteAddress();
                    Host host = new Host(address, connection);
                    host.setType(Host.Type.INCOMING);
                    host.setStatus(HostStatus.ACCEPTING, "");
                    ConnectionEngine engine = new ConnectionEngine(this.servent, host);
                    engine.initHostHandshake();
                    engine.processIncomingData();
                    break block18;
                }
                if (requestLine.startsWith(GET_REQUEST_PREFIX) || requestLine.startsWith(HEAD_REQUEST_PREFIX)) {
                    if (!this.servent.getOnlineStatus().isTransfersOnline() && !this.socket.getRemoteAddress().isLocalHost(localAddress)) {
                        throw new IOException("Transfers not connected.");
                    }
                    HTTPRequest httpRequest = HTTPProcessor.parseHTTPRequest(requestLine);
                    HTTPProcessor.parseHTTPHeaders(httpRequest, connection);
                    NLogger.debug(IncomingConnectionDispatcher.class, (Object)(httpRequest.getRequestMethod() + " Request: " + httpRequest.buildHTTPRequestString()));
                    if (httpRequest.isGnutellaRequest()) {
                        this.servent.getUploadService().handleUploadRequest(connection, httpRequest);
                    } else {
                        new HttpRequestDispatcher().httpRequestHandler(connection, httpRequest);
                    }
                    break block18;
                }
                if (requestLine.startsWith(GIV_REQUEST_PREFIX)) {
                    if (!this.servent.getOnlineStatus().isTransfersOnline() && !this.socket.getRemoteAddress().isLocalHost(localAddress)) {
                        throw new IOException("Transfers not connected.");
                    }
                    this.handleIncommingGIV(requestLine);
                    break block18;
                }
                if (requestLine.startsWith(CHAT_REQUEST_PREFIX)) {
                    if (!this.servent.getOnlineStatus().isNetworkOnline() && !this.socket.getRemoteAddress().isLocalHost(localAddress)) {
                        throw new IOException("Network not connected.");
                    }
                    DestAddress address = this.socket.getRemoteAddress();
                    NLogger.debug(IncomingConnectionDispatcher.class, (Object)("Chat request from: " + address));
                    this.servent.getChatService().acceptChat(connection);
                    break block18;
                }
                if (requestLine.startsWith(URI_DOWNLOAD_PREFIX)) {
                    this.handleIncommingUriDownload(requestLine);
                    break block18;
                }
                if (requestLine.startsWith(MAGMA_DOWNLOAD_PREFIX)) {
                    this.handleIncommingMagmaDownload(requestLine);
                    break block18;
                }
                if (requestLine.startsWith(RSS_DOWNLOAD_PREFIX)) {
                    this.handleIncommingRSSDownload(requestLine);
                    break block18;
                }
                throw new IOException("Unknown connection request: " + requestLine);
            }
            catch (HTTPMessageException exp) {
                NLogger.debug(IncomingConnectionDispatcher.class, (Object)exp, (Throwable)exp);
                IOUtil.closeQuietly(gInStream);
                IOUtil.closeQuietly(this.socket);
            }
            catch (IOException exp) {
                NLogger.debug(IncomingConnectionDispatcher.class, (Object)exp, (Throwable)exp);
                IOUtil.closeQuietly(gInStream);
                IOUtil.closeQuietly(this.socket);
            }
            catch (Exception exp) {
                NLogger.error(IncomingConnectionDispatcher.class, (Object)exp, (Throwable)exp);
                IOUtil.closeQuietly(gInStream);
                IOUtil.closeQuietly(this.socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingUriDownload(String requestLine) throws IOException {
        try {
            DestAddress localAddress = this.servent.getLocalAddress();
            if (!this.socket.getRemoteAddress().isLocalHost(localAddress)) {
                return;
            }
            this.socket.getChannel().write(BufferCache.OK_BUFFER);
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        String uriToken = requestLine.substring(URI_DOWNLOAD_PREFIX.length() + 1);
        PhexEventService eventService = this.servent.getEventService();
        eventService.publish("phex:incoming/uri", uriToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingMagmaDownload(String requestLine) throws IOException {
        try {
            DestAddress localAddress = this.servent.getLocalAddress();
            if (!this.socket.getRemoteAddress().isLocalHost(localAddress)) {
                return;
            }
            this.socket.getChannel().write(BufferCache.OK_BUFFER);
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        String fileNameToken = requestLine.substring(MAGMA_DOWNLOAD_PREFIX.length() + 1);
        PhexEventService eventService = this.servent.getEventService();
        eventService.publish("phex:incoming/magma", fileNameToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingRSSDownload(String requestLine) throws IOException {
        try {
            DestAddress localAddress = this.servent.getLocalAddress();
            if (!this.socket.getRemoteAddress().isLocalHost(localAddress)) {
                return;
            }
            this.socket.getChannel().write(BufferCache.OK_BUFFER);
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        String fileNameToken = requestLine.substring(RSS_DOWNLOAD_PREFIX.length() + 1);
        PhexEventService eventService = this.servent.getEventService();
        eventService.publish("phex:incoming/magma", fileNameToken);
    }

    private void handleIncommingGIV(String requestLine) {
        String remainder = requestLine.substring(4);
        try {
            int fileNumIdx = remainder.indexOf(58);
            int guidIdx = remainder.indexOf(47, fileNumIdx);
            String guidStr = remainder.substring(fileNumIdx + 1, guidIdx);
            String givenFileName = remainder.substring(guidIdx + 1);
            givenFileName = URLCodecUtils.decodeURL(givenFileName);
            GUID givenGUID = new GUID(guidStr);
            PushHandler.handleIncommingGIV(this.socket, givenGUID, givenFileName);
        }
        catch (IndexOutOfBoundsException exp) {
            NLogger.error(IncomingConnectionDispatcher.class, (Object)("Failed to parse GIV: " + requestLine), (Throwable)exp);
        }
    }
}

