/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.IOException;
import java.io.OutputStream;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;

public class ManagedFileOutputStream
extends OutputStream {
    private ByteBuffer buffer;
    private ManagedFile managedFile;
    private long outputPosition;

    public ManagedFileOutputStream(ManagedFile managedFile, long outputPosition) {
        this.managedFile = managedFile;
        this.outputPosition = outputPosition;
        this.buffer = ByteBuffer.allocate(65536);
    }

    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.flush();
        }
        this.buffer.put((byte)b);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        int toWrite;
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        for (int written = 0; written < length; written += toWrite) {
            toWrite = Math.min(length - written, this.buffer.remaining());
            this.buffer.put(b, offset + written, toWrite);
            if (this.buffer.hasRemaining()) continue;
            this.flush();
        }
        if (NLogger.isDebugEnabled(ManagedFileOutputStream.class)) {
            NLogger.debug(ManagedFileOutputStream.class, (Object)("Writen: " + new String(b, offset, length)));
        }
    }

    public void flush() throws IOException {
        this.buffer.flip();
        try {
            this.managedFile.write(this.buffer, this.outputPosition);
        }
        catch (ManagedFileException exp) {
            IOException ioExp = new IOException("ManagedFileException: " + exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
        this.outputPosition += (long)this.buffer.limit();
        this.buffer.clear();
        if (NLogger.isDebugEnabled(ManagedFileOutputStream.class)) {
            NLogger.debug(ManagedFileOutputStream.class, (Object)"Flushed");
        }
    }

    public void close() throws IOException {
        this.flush();
        this.buffer = null;
    }
}

