/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.IOException;
import java.io.InputStream;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;

public class ManagedFileInputStream
extends InputStream {
    private ByteBuffer buffer;
    private ManagedFile managedFile;
    private long inputOffset;

    public ManagedFileInputStream(ManagedFile managedFile, long inputOffset) {
        this.managedFile = managedFile;
        this.inputOffset = inputOffset;
        this.buffer = ByteBuffer.allocate(65536);
        this.buffer.flip();
    }

    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.fill();
        }
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        byte b = this.buffer.get();
        if (NLogger.isDebugEnabled(ManagedFileInputStream.class)) {
            NLogger.debug(ManagedFileInputStream.class, (Object)("Read: " + (char)b));
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int read;
        int toRead;
        if ((offset | length | offset + length | b.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if (!this.buffer.hasRemaining()) {
            this.fill();
        }
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        for (read = 0; read < length && this.buffer.hasRemaining(); read += toRead) {
            toRead = Math.min(length - read, this.buffer.remaining());
            this.buffer.get(b, offset + read, toRead);
            if (this.buffer.hasRemaining()) continue;
            this.fill();
        }
        if (NLogger.isDebugEnabled(ManagedFileInputStream.class)) {
            NLogger.debug(ManagedFileInputStream.class, (Object)("Read: " + new String(b, offset, read)));
        }
        return read;
    }

    public int available() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.fill();
        }
        return this.buffer.remaining();
    }

    private void fill() throws IOException {
        assert (!this.buffer.hasRemaining());
        this.buffer.clear();
        try {
            this.managedFile.read(this.buffer, this.inputOffset);
        }
        catch (ManagedFileException exp) {
            IOException ioExp = new IOException("Cause: " + exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
        this.buffer.flip();
        this.inputOffset += (long)this.buffer.limit();
    }

    public void close() throws IOException {
        this.buffer = null;
    }
}

