/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.event.ChangeEvent;
import phex.event.PhexEventService;
import phex.net.Server;

public class LocalServentAddress
implements DestAddress {
    private final Server server;
    private final PhexEventService eventService;
    private DestAddress forcedAddress;
    private DestAddress localAddress;

    public LocalServentAddress(Server server, PhexEventService eventService) {
        this.server = server;
        this.eventService = eventService;
        this.localAddress = null;
    }

    public void updateLocalAddress(DestAddress updateAddress) {
        if (updateAddress != null) {
            this.localAddress = updateAddress;
            this.fireNetworkIPChanged(this.localAddress);
        }
    }

    public void setForcedHostIP(IpAddress forcedHostIP) {
    }

    private void fireNetworkIPChanged(DestAddress newAddress) {
        this.eventService.publish("phex:servent/localAddress", new ChangeEvent(this, null, newAddress));
    }

    protected DestAddress getEffectiveAddress() {
        return this.forcedAddress != null ? this.forcedAddress : this.localAddress;
    }

    public boolean equals(DestAddress address) {
        return this.getEffectiveAddress().equals(address);
    }

    public boolean equals(byte[] ipAddress, int port) {
        return this.getEffectiveAddress().equals(ipAddress, port);
    }

    public String getCountryCode() {
        return this.getEffectiveAddress().getCountryCode();
    }

    public String getFullHostName() {
        return this.getEffectiveAddress().getFullHostName();
    }

    public String getHostName() {
        return this.getEffectiveAddress().getHostName();
    }

    public IpAddress getIpAddress() {
        return this.getEffectiveAddress().getIpAddress();
    }

    public int getPort() {
        return this.getEffectiveAddress().getPort();
    }

    public boolean isIpHostName() {
        return this.getEffectiveAddress().isIpHostName();
    }

    public boolean isLocalHost(DestAddress localAddress) {
        return this.getEffectiveAddress().isLocalHost(localAddress);
    }

    public boolean isSiteLocalAddress() {
        return this.getEffectiveAddress().isSiteLocalAddress();
    }

    public boolean isValidAddress() {
        return this.getEffectiveAddress().isValidAddress();
    }

    @Deprecated
    public void setPort(int port) {
        this.getEffectiveAddress().setPort(port);
    }
}

