/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.msg.InvalidMessageException;
import phex.msg.PongMsg;
import phex.msghandling.MessageSubscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizonTracker
implements MessageSubscriber<PongMsg> {
    private static final int MAX_PONG_COUNT = 10000;
    private boolean useLastCountValues;
    private Set<DestAddress> trackedAddresses;
    private int currentHostCount;
    private long currentFileCount;
    private long currentFileSize;
    private int lastHostCount;
    private long lastFileCount;
    private long lastFileSize;

    public HorizonTracker() {
        Environment.getInstance().scheduleTimerTask(new TrackerRefreshTimer(), 900000L, 900000L);
        this.useLastCountValues = false;
        this.trackedAddresses = new HashSet<DestAddress>();
    }

    public long getTotalFileCount() {
        return this.useLastCountValues ? this.lastFileCount : this.currentFileCount;
    }

    public long getTotalFileSize() {
        return this.useLastCountValues ? this.lastFileSize : this.currentFileSize;
    }

    public int getTotalHostCount() {
        return this.useLastCountValues ? this.lastHostCount : this.currentHostCount;
    }

    @Override
    public synchronized void onMessage(PongMsg message, Host sourceHost) throws InvalidMessageException {
        if (this.trackedAddresses.size() > 10000) {
            return;
        }
        boolean isAdded = this.trackedAddresses.add(message.getPongAddress());
        if (isAdded) {
            this.currentFileCount += message.getFileCount();
            this.currentFileSize += message.getFileSizeInKB();
            ++this.currentHostCount;
        }
    }

    private synchronized void refreshTrackerStats() {
        this.lastHostCount = this.currentHostCount;
        this.lastFileCount = this.currentFileCount;
        this.lastFileSize = this.currentFileSize;
        this.useLastCountValues = true;
        this.currentFileCount = 0L;
        this.currentFileSize = 0L;
        this.currentHostCount = 0;
        this.trackedAddresses.clear();
    }

    private class TrackerRefreshTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 900000L;

        private TrackerRefreshTimer() {
        }

        public void run() {
            try {
                HorizonTracker.this.refreshTrackerStats();
            }
            catch (Throwable th) {
                NLogger.error(TrackerRefreshTimer.class, (Object)th, th);
            }
        }
    }
}

