/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.SystemUtils;
import phex.common.JThreadPool;
import phex.common.log.NLogger;
import phex.event.UserMessageListener;
import phex.utils.SystemProperties;
import phex.utils.VersionUtils;

public class Environment {
    private Properties properties;
    private UserMessageListener userMessageListener;
    private Timer timerService;
    private JThreadPool threadPool;

    private Environment() {
        try {
            this.properties = new Properties();
            this.properties.load(Environment.class.getResourceAsStream("/phex/resources/version.properties"));
        }
        catch (IOException exp) {
            NLogger.error(Environment.class, (Object)exp, (Throwable)exp);
            throw new RuntimeException();
        }
        this.timerService = new Timer(true);
        this.threadPool = new JThreadPool();
    }

    public static Environment getInstance() {
        return Holder.environment;
    }

    public File getPhexConfigFile(String configFileName) {
        return new File(SystemProperties.getPhexConfigRoot(), configFileName);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public static String getPhexVendor() {
        return "Phex " + VersionUtils.getFullProgramVersion();
    }

    public void scheduleTimerTask(TimerTask task, long delay, long period) {
        this.timerService.schedule(task, delay, period);
    }

    public void scheduleTimerTask(TimerTask task, long delay) {
        this.timerService.schedule(task, delay);
    }

    public void executeOnThreadPool(Runnable runnable, String name) {
        this.threadPool.executeNamed(runnable, name);
    }

    public boolean isUltrapeerOS() {
        return !SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_WINDOWS_2000 || SystemUtils.IS_OS_WINDOWS_XP;
    }

    public void setUserMessageListener(UserMessageListener listener) {
        this.userMessageListener = listener;
    }

    public void fireDisplayUserMessage(String userMessageId) {
        if (this.userMessageListener != null) {
            this.userMessageListener.displayUserMessage(userMessageId, null);
        }
    }

    public void fireDisplayUserMessage(String userMessageId, String[] args) {
        if (this.userMessageListener != null) {
            this.userMessageListener.displayUserMessage(userMessageId, args);
        }
    }

    private static class Holder {
        protected static final Environment environment = new Environment();

        private Holder() {
        }
    }
}

