/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.ThreadTracking;
import phex.common.log.NLogger;
import phex.event.PhexEventService;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.common.SplashWindow;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.prefs.PhexGuiPrefs;
import phex.prefs.OldCfg;
import phex.prefs.core.PhexCorePrefs;
import phex.servent.Servent;
import phex.utils.FileUtils;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static void main(String[] args) {
        String argument;
        long start = System.currentTimeMillis();
        Main.validateJavaVersion();
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while ((argument = Main.readArgument(iterator)) != null) {
            if (!argument.equalsIgnoreCase("-c")) continue;
            System.out.println("Config path argument found!");
            String path = Main.readArgument(iterator);
            if (path == null) continue;
            System.out.println("Config path set to [" + path + "].");
            System.setProperty("phex.config.path", path);
        }
        PhexCorePrefs.init();
        try {
            SplashWindow splashWindow = null;
            try {
                splashWindow = new SplashWindow();
                splashWindow.showSplash();
            }
            catch (HeadlessException ex) {
                // empty catch block
            }
            PhexGuiPrefs.init();
            File oldConfigFile = Environment.getInstance().getPhexConfigFile("phex.cfg");
            if (oldConfigFile.exists()) {
                OldCfg oldCfg = new OldCfg(oldConfigFile);
                oldCfg.load();
                PhexGuiPrefs.updatePreV30Config(oldCfg);
                PhexCorePrefs.updatePreV30Config(oldCfg);
                FileUtils.deleteFileMultiFallback(oldConfigFile);
            }
            Localizer.initialize(InterfacePrefs.LocaleName.get());
            ThreadTracking.initialize();
            Servent.getInstance();
            Servent.getInstance().start();
            long end = System.currentTimeMillis();
            NLogger.debug(Main.class, (Object)("Pre GUI startup time: " + (end - start)));
            try {
                GUIRegistry.getInstance().initialize(Servent.getInstance());
            }
            catch (ExceptionInInitializerError ex) {
                // empty catch block
            }
            if (splashWindow != null) {
                splashWindow.dispose();
            }
            MainFrame mainFrame = null;
            mainFrame = GUIRegistry.getInstance().getMainFrame();
            if (mainFrame != null) {
                mainFrame.setVisible(true);
            }
            end = System.currentTimeMillis();
            NLogger.debug(Main.class, (Object)("Full startup time: " + (end - start)));
            PhexEventService eventService = Servent.getInstance().getEventService();
        }
        catch (Throwable th) {
            th.printStackTrace();
            NLogger.error(Main.class, (Object)th, th);
            System.exit(1);
        }
    }

    private static String readArgument(Iterator<String> iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        String value = iterator.next();
        return value;
    }

    private static void validateJavaVersion() {
        if (SystemUtils.isJavaVersionAtLeast(1.5f)) {
            return;
        }
        JFrame frame = new JFrame("Wrong Java Version");
        frame.setSize(new Dimension(0, 0));
        frame.setVisible(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = frame.getSize();
        Rectangle rect = new Rectangle((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2, winSize.width, winSize.height);
        frame.setBounds(rect);
        JOptionPane.showMessageDialog(frame, "Please use a newer Java VM.\nPhex requires at least Java 1.5.0. You are using Java " + SystemUtils.JAVA_VERSION + "\n" + "To get the latest Java release go to http://java.com.", "Wrong Java Version", 2);
        System.exit(1);
    }
}

