/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.annotation.BaseProxySubscriber;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.bushe.swing.event.annotation.EventTopicPatternSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicPatternSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicSubscriber;
import org.bushe.swing.event.annotation.UseTheClassOfTheAnnotatedMethodsParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessor {
    public static void process(Object obj) {
        if (obj == null) {
            return;
        }
        Class<?> cl = obj.getClass();
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            EventTopicPatternSubscriber topicPatternAnnotation;
            org.bushe.swing.event.annotation.EventTopicSubscriber topicAnnotation;
            Method method = methods[i];
            EventSubscriber classAnnotation = method.getAnnotation(EventSubscriber.class);
            if (classAnnotation != null) {
                AnnotationProcessor.process(classAnnotation, obj, method);
            }
            if ((topicAnnotation = method.getAnnotation(org.bushe.swing.event.annotation.EventTopicSubscriber.class)) != null) {
                AnnotationProcessor.process(topicAnnotation, obj, method);
            }
            if ((topicPatternAnnotation = method.getAnnotation(EventTopicPatternSubscriber.class)) == null) continue;
            AnnotationProcessor.process(topicPatternAnnotation, obj, method);
        }
    }

    private static void process(EventTopicPatternSubscriber topicPatternAnnotation, Object obj, Method method) {
        String topicPattern = topicPatternAnnotation.topicPattern();
        if (topicPattern == null) {
            throw new IllegalArgumentException("Topic pattern cannot be null for EventTopicPatternSubscriber annotation");
        }
        Class<? extends EventService> eventServiceClass = topicPatternAnnotation.autoCreateEventServiceClass();
        String eventServiceName = topicPatternAnnotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        Pattern pattern = Pattern.compile(topicPattern);
        ProxyTopicPatternSubscriber subscriber = new ProxyTopicPatternSubscriber(obj, method, topicPatternAnnotation.referenceStrength(), eventService, topicPattern, pattern);
        eventService.subscribeStrongly(pattern, (EventTopicSubscriber)subscriber);
    }

    private static void process(org.bushe.swing.event.annotation.EventTopicSubscriber topicAnnotation, Object obj, Method method) {
        String topic = topicAnnotation.topic();
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null for EventTopicSubscriber annotation");
        }
        Class<? extends EventService> eventServiceClass = topicAnnotation.autoCreateEventServiceClass();
        String eventServiceName = topicAnnotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        ProxyTopicSubscriber subscriber = new ProxyTopicSubscriber(obj, method, topicAnnotation.referenceStrength(), eventService, topic);
        eventService.subscribeStrongly(topic, (EventTopicSubscriber)subscriber);
    }

    private static void process(EventSubscriber annotation, Object obj, Method method) {
        Class<?> eventClass = annotation.eventClass();
        if (eventClass == null) {
            throw new IllegalArgumentException("Event class cannot be null for EventSubscriber annotation");
        }
        if (UseTheClassOfTheAnnotatedMethodsParameter.class.equals((Object)eventClass)) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length < 1) {
                throw new RuntimeException("Expected annotated method to have one parameter.");
            }
            eventClass = params[0];
        }
        Class<? extends EventService> eventServiceClass = annotation.autoCreateEventServiceClass();
        String eventServiceName = annotation.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(eventServiceName, eventServiceClass);
        BaseProxySubscriber subscriber = new BaseProxySubscriber(obj, method, annotation.referenceStrength(), eventService, eventClass);
        if (annotation.exact()) {
            eventService.subscribeExactlyStrongly(eventClass, subscriber);
        } else {
            eventService.subscribeStrongly(eventClass, subscriber);
        }
    }

    private static EventService getEventServiceFromAnnotation(String eventServiceName, Class<? extends EventService> eventServiceClass) {
        EventService eventService = EventServiceLocator.getEventService(eventServiceName);
        if (eventService == null) {
            if ("EventBus".equals(eventServiceName)) {
                eventService = EventServiceLocator.getSwingEventService();
            } else {
                try {
                    eventService = eventServiceClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Could not instance of create EventService class " + eventServiceClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Could not instance of create EventService class " + eventServiceClass, e);
                }
                try {
                    EventServiceLocator.setEventService(eventServiceName, eventService);
                }
                catch (EventServiceExistsException e) {
                    eventService = EventServiceLocator.getEventService(eventServiceName);
                }
            }
        }
        return eventService;
    }
}

