/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.MessageOutputStream;
import net.i2p.data.Destination;

class I2PSocketFull
implements I2PSocket {
    private Connection _connection;
    private I2PSocket.SocketErrorListener _listener;
    private Destination _remotePeer;
    private Destination _localPeer;

    public I2PSocketFull(Connection con) {
        this._connection = con;
        if (con != null) {
            this._remotePeer = con.getRemotePeer();
            this._localPeer = con.getSession().getMyDestination();
        }
    }

    public void close() throws IOException {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (c.getIsConnected()) {
            MessageOutputStream out = c.getOutputStream();
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            c.disconnect(true);
        }
        this.destroy();
    }

    Connection getConnection() {
        return this._connection;
    }

    public InputStream getInputStream() {
        Connection c = this._connection;
        if (c != null) {
            return c.getInputStream();
        }
        return null;
    }

    public I2PSocketOptions getOptions() {
        Connection c = this._connection;
        if (c != null) {
            return c.getOptions();
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        Connection c = this._connection;
        if (c != null) {
            return c.getOutputStream();
        }
        return null;
    }

    public Destination getPeerDestination() {
        return this._remotePeer;
    }

    public long getReadTimeout() {
        I2PSocketOptions opts = this.getOptions();
        if (opts != null) {
            return opts.getReadTimeout();
        }
        return -1L;
    }

    public Destination getThisDestination() {
        return this._localPeer;
    }

    public void setOptions(I2PSocketOptions options) {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        if (options instanceof ConnectionOptions) {
            c.setOptions((ConnectionOptions)options);
        } else {
            c.setOptions(new ConnectionOptions(options));
        }
    }

    public void setReadTimeout(long ms) {
        Connection c = this._connection;
        if (c == null) {
            return;
        }
        c.getInputStream().setReadTimeout((int)ms);
        c.getOptions().setReadTimeout(ms);
    }

    public void setSocketErrorListener(I2PSocket.SocketErrorListener lsnr) {
        this._listener = lsnr;
    }

    public boolean isClosed() {
        Connection c = this._connection;
        return c == null || !c.getIsConnected() || c.getResetReceived() || c.getResetSent();
    }

    void destroy() {
        Connection c = this._connection;
        this._connection = null;
        this._listener = null;
        if (c != null) {
            c.disconnectComplete();
        }
    }

    public String toString() {
        Connection c = this._connection;
        if (c == null) {
            return super.toString();
        }
        return c.toString();
    }
}

