/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.MessageOutputStream;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.util.Log;

class ConnectionDataReceiver
implements MessageOutputStream.DataReceiver {
    private I2PAppContext _context;
    private Log _log;
    private Connection _connection;
    private static final MessageOutputStream.WriteStatus _dummyStatus = new DummyStatus();

    public ConnectionDataReceiver(I2PAppContext ctx, Connection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ConnectionDataReceiver.class);
        this._connection = con;
    }

    public boolean writeInProcess() {
        Connection con = this._connection;
        if (con != null) {
            return con.getUnackedPacketsSent() >= con.getOptions().getWindowSize();
        }
        return false;
    }

    public MessageOutputStream.WriteStatus writeData(byte[] buf, int off, int size) {
        Connection con = this._connection;
        if (con == null) {
            return _dummyStatus;
        }
        boolean doSend = true;
        if (size <= 0 && con.getLastSendId() >= 0L) {
            doSend = con.getOutputStream().getClosed() ? con.getCloseSentOn() < 0L : false;
        }
        if (con.getUnackedPacketsReceived() > 0) {
            doSend = true;
        }
        if (this._log.shouldLog(20) && !doSend) {
            this._log.info("writeData called: size=" + size + " doSend=" + doSend + " unackedReceived: " + con.getUnackedPacketsReceived() + " con: " + con, (Throwable)new Exception("write called by"));
        }
        if (doSend) {
            PacketLocal packet = this.send(buf, off, size);
            if (packet == null) {
                return _dummyStatus;
            }
            if (packet.getSequenceNum() > 0L || packet.isFlagSet(1)) {
                return packet;
            }
            return _dummyStatus;
        }
        return _dummyStatus;
    }

    public PacketLocal send(byte[] buf, int off, int size) {
        return this.send(buf, off, size, false);
    }

    public PacketLocal send(byte[] buf, int off, int size, boolean forceIncrement) {
        Connection con = this._connection;
        if (con == null) {
            return null;
        }
        long before = System.currentTimeMillis();
        PacketLocal packet = this.buildPacket(con, buf, off, size, forceIncrement);
        long built = System.currentTimeMillis();
        con.sendPacket(packet);
        long sent = System.currentTimeMillis();
        if (built - before > 5000L && this._log.shouldLog(30)) {
            this._log.warn("wtf, took " + (built - before) + "ms to build a packet: " + packet);
        }
        if (sent - built > 5000L && this._log.shouldLog(30)) {
            this._log.warn("wtf, took " + (sent - built) + "ms to send a packet: " + packet);
        }
        return packet;
    }

    private boolean isAckOnly(Connection con, int size) {
        boolean ackOnly = size <= 0 && con.getLastSendId() >= 0L && (!con.getOutputStream().getClosed() || con.getOutputStream().getClosed() && con.getCloseSentOn() > 0L);
        return ackOnly;
    }

    private PacketLocal buildPacket(Connection con, byte[] buf, int off, int size, boolean forceIncrement) {
        if (size > 32768) {
            throw new IllegalArgumentException("size is too large (" + size + ")");
        }
        boolean ackOnly = this.isAckOnly(con, size);
        boolean isFirst = con.getAckedPackets() <= 0L && con.getUnackedPacketsSent() <= 0;
        PacketLocal packet = new PacketLocal(this._context, con.getRemotePeer(), con);
        ByteArray data = new ByteArray(new byte[size]);
        if (size > 0) {
            System.arraycopy(buf, off, data.getData(), 0, size);
        }
        data.setValid(size);
        data.setOffset(0);
        packet.setPayload(data);
        if (ackOnly && !forceIncrement && !isFirst) {
            packet.setSequenceNum(0L);
        } else {
            packet.setSequenceNum(con.getNextOutboundPacketNum());
        }
        packet.setSendStreamId(con.getSendStreamId());
        packet.setReceiveStreamId(con.getReceiveStreamId());
        con.getInputStream().updateAcks(packet);
        int choke = con.getOptions().getChoke();
        packet.setOptionalDelay(choke);
        if (choke > 0) {
            packet.setFlag(64);
        }
        packet.setResendDelay(con.getOptions().getResendDelay() / 1000);
        if (con.getOptions().getProfile() == 2) {
            packet.setFlag(256, true);
        } else {
            packet.setFlag(256, false);
        }
        packet.setFlag(16, con.getOptions().getRequireFullySigned());
        if (isFirst) {
            packet.setFlag(1);
            packet.setOptionalFrom(con.getSession().getMyDestination());
            packet.setOptionalMaxSize(con.getOptions().getMaxMessageSize());
        }
        if (con.getSendStreamId() == 0L) {
            packet.setFlag(1024);
        }
        if (con.getOutputStream().getClosed() && (size > 0 || con.getUnackedPacketsSent() <= 0 || packet.getSequenceNum() > 0L)) {
            packet.setFlag(2);
            con.setCloseSentOn(this._context.clock().now());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("New outbound packet on " + this._connection + ": " + packet);
        }
        return packet;
    }

    void destroy() {
    }

    private static final class DummyStatus
    implements MessageOutputStream.WriteStatus {
        private DummyStatus() {
        }

        public final void waitForAccept(int maxWaitMs) {
        }

        public final void waitForCompletion(int maxWaitMs) {
        }

        public final boolean writeAccepted() {
            return true;
        }

        public final boolean writeFailed() {
            return false;
        }

        public final boolean writeSuccessful() {
            return true;
        }
    }
}

