/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.ConnectionDataReceiver;
import net.i2p.client.streaming.ConnectionManager;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.ConnectionPacketHandler;
import net.i2p.client.streaming.I2PSocketFull;
import net.i2p.client.streaming.MessageInputStream;
import net.i2p.client.streaming.MessageOutputStream;
import net.i2p.client.streaming.Packet;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.client.streaming.PacketQueue;
import net.i2p.client.streaming.RetransmissionTimer;
import net.i2p.client.streaming.SchedulerChooser;
import net.i2p.client.streaming.TaskScheduler;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Connection {
    private I2PAppContext _context;
    private Log _log;
    private ConnectionManager _connectionManager;
    private Destination _remotePeer;
    private long _sendStreamId;
    private long _receiveStreamId;
    private long _lastSendTime;
    private AtomicLong _lastSendId;
    private boolean _resetReceived;
    private boolean _resetSent;
    private long _resetSentOn;
    private boolean _connected;
    private boolean _hardDisconnected;
    private MessageInputStream _inputStream;
    private MessageOutputStream _outputStream;
    private SchedulerChooser _chooser;
    private long _nextSendTime;
    private long _ackedPackets;
    private long _createdOn;
    private long _closeSentOn;
    private long _closeReceivedOn;
    private int _unackedPacketsReceived;
    private long _congestionWindowEnd;
    private long _highestAckedThrough;
    private boolean _isInbound;
    private boolean _updatedShareOpts;
    private final Map<Long, PacketLocal> _outboundPackets;
    private PacketQueue _outboundQueue;
    private ConnectionPacketHandler _handler;
    private ConnectionOptions _options;
    private ConnectionDataReceiver _receiver;
    private I2PSocketFull _socket;
    private String _connectionError;
    private long _disconnectScheduledOn;
    private long _lastReceivedOn;
    private ActivityTimer _activityTimer;
    private int _lastCongestionSeenAt;
    private long _lastCongestionTime;
    private long _lastCongestionHighestUnacked;
    private boolean _ackSinceCongestion;
    private final Object _connectLock;
    private int _activeResends;
    private ConEvent _connectionEvent;
    private int _randomWait;
    private long _lifetimeBytesSent;
    private long _lifetimeBytesReceived;
    private long _lifetimeDupMessageSent;
    private long _lifetimeDupMessageReceived;
    public static final long MAX_RESEND_DELAY = 45000L;
    public static final long MIN_RESEND_DELAY = 2000L;
    public static final int DISCONNECT_TIMEOUT = 300000;
    public static final int MAX_WINDOW_SIZE = 128;
    private long _occurredTime;
    private long _occurredEventCount;
    private boolean _remotePeerSet = false;
    private boolean _sendStreamIdSet = false;
    private boolean _receiveStreamIdSet = false;
    static final int FAST_RETRANSMIT_THRESHOLD = 2;

    public Connection(I2PAppContext ctx, ConnectionManager manager, SchedulerChooser chooser, PacketQueue queue, ConnectionPacketHandler handler) {
        this(ctx, manager, chooser, queue, handler, null);
    }

    public Connection(I2PAppContext ctx, ConnectionManager manager, SchedulerChooser chooser, PacketQueue queue, ConnectionPacketHandler handler, ConnectionOptions opts) {
        this._context = ctx;
        this._connectionManager = manager;
        this._chooser = chooser;
        this._outboundQueue = queue;
        this._handler = handler;
        this._log = this._context.logManager().getLog(Connection.class);
        this._receiver = new ConnectionDataReceiver(this._context, this);
        this._inputStream = new MessageInputStream(this._context);
        this._outputStream = new MessageOutputStream(this._context, this._receiver, opts == null ? 32768 : opts.getMaxMessageSize());
        this._outboundPackets = new TreeMap<Long, PacketLocal>();
        this._options = opts != null ? opts : new ConnectionOptions();
        this._outputStream.setWriteTimeout((int)this._options.getWriteTimeout());
        this._inputStream.setReadTimeout((int)this._options.getReadTimeout());
        this._lastSendId = new AtomicLong(-1L);
        this._nextSendTime = -1L;
        this._ackedPackets = 0L;
        this._createdOn = this._context.clock().now();
        this._closeSentOn = -1L;
        this._closeReceivedOn = -1L;
        this._unackedPacketsReceived = 0;
        this._congestionWindowEnd = this._options.getWindowSize() - 1;
        this._highestAckedThrough = -1L;
        this._lastCongestionSeenAt = 256;
        this._lastCongestionTime = -1L;
        this._lastCongestionHighestUnacked = -1L;
        this._resetReceived = false;
        this._connected = true;
        this._disconnectScheduledOn = -1L;
        this._lastReceivedOn = -1L;
        this._activityTimer = new ActivityTimer();
        this._ackSinceCongestion = true;
        this._connectLock = new Object();
        this._activeResends = 0;
        this._resetSentOn = -1L;
        this._isInbound = false;
        this._updatedShareOpts = false;
        this._connectionEvent = new ConEvent();
        this._hardDisconnected = false;
        this._randomWait = this._context.random().nextInt(10000);
        this._context.statManager().createRateStat("stream.con.windowSizeAtCongestion", "How large was our send window when we send a dup?", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.chokeSizeBegin", "How many messages were outstanding when we started to choke?", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.chokeSizeEnd", "How many messages were outstanding when we stopped being choked?", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.fastRetransmit", "How long a packet has been around for if it has been resent per the fast retransmit timer?", "Stream", new long[]{60000L, 600000L});
        if (this._log.shouldLog(20)) {
            this._log.info("New connection created with options: " + (Object)((Object)this._options));
        }
    }

    public long getNextOutboundPacketNum() {
        return this._lastSendId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeReceived() {
        this.setCloseReceivedOn(this._context.clock().now());
        this._inputStream.closeReceived();
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean packetSendChoke(long timeoutMs) {
        long start = this._context.clock().now();
        long writeExpire = start + timeoutMs;
        boolean started = false;
        while (true) {
            long timeLeft = writeExpire - this._context.clock().now();
            Map<Long, PacketLocal> map = this._outboundPackets;
            synchronized (map) {
                if (!started) {
                    this._context.statManager().addRateData("stream.chokeSizeBegin", (long)this._outboundPackets.size(), timeoutMs);
                }
                if (start + 300000L < this._context.clock().now()) {
                    return false;
                }
                if (!this._connected) {
                    return false;
                }
                started = true;
                if (this._outboundPackets.size() >= this._options.getWindowSize() || this._activeResends > 0 || this._lastSendId.get() - this._highestAckedThrough > (long)this._options.getWindowSize()) {
                    if (timeoutMs > 0L) {
                        if (timeLeft <= 0L) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("Outbound window is full of " + this._outboundPackets.size() + " with " + this._activeResends + " active resends" + " and we've waited too long (" + (0L - (timeLeft - timeoutMs)) + "ms): " + this.toString());
                            }
                            return false;
                        }
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Outbound window is full (" + this._outboundPackets.size() + "/" + this._options.getWindowSize() + "/" + this._activeResends + "), waiting " + timeLeft);
                        }
                        try {
                            this._outboundPackets.wait(Math.min(timeLeft, 250L));
                        }
                        catch (InterruptedException ie) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("InterruptedException while Outbound window is full (" + this._outboundPackets.size() + "/" + this._activeResends + ")");
                            }
                            return false;
                        }
                    } else {
                        try {
                            this._outboundPackets.wait(250L);
                        }
                        catch (InterruptedException ie) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("InterruptedException while Outbound window is full (" + this._outboundPackets.size() + "/" + this._activeResends + ")");
                            }
                            return false;
                        }
                    }
                } else {
                    this._context.statManager().addRateData("stream.chokeSizeEnd", (long)this._outboundPackets.size(), this._context.clock().now() - start);
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void windowAdjusted() {
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            this._outboundPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ackImmediately() {
        Packet packet = null;
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            if (!this._outboundPackets.isEmpty()) {
                Iterator<PacketLocal> iter = this._outboundPackets.values().iterator();
                packet = iter.next();
            }
        }
        if (packet != null) {
            if (packet.isFlagSet(4)) {
                this.sendReset();
                return;
            }
            ResendPacketEvent evt = (ResendPacketEvent)((PacketLocal)packet).getResendEvent();
            if (evt != null) {
                boolean sent = evt.retransmit(false);
                if (sent) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Retransmitting " + packet + " as an ack");
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Not retransmitting " + packet + " as an ack");
                }
            }
        }
        packet = this._receiver.send(null, 0, 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending new ack: " + packet);
        }
    }

    void sendReset() {
        long now;
        if (this._disconnectScheduledOn < 0L) {
            this._disconnectScheduledOn = this._context.clock().now();
            SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new DisconnectEvent(), 300000L);
        }
        if (this._resetSentOn + 10000L > (now = this._context.clock().now())) {
            return;
        }
        if (this._resetReceived) {
            return;
        }
        this._resetSent = true;
        if (this._resetSentOn <= 0L) {
            this._resetSentOn = now;
        }
        if (this._remotePeer == null || this._sendStreamId <= 0L) {
            return;
        }
        PacketLocal reply = new PacketLocal(this._context, this._remotePeer);
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setSendStreamId(this._sendStreamId);
        reply.setReceiveStreamId(this._receiveStreamId);
        reply.setOptionalFrom(this._connectionManager.getSession().getMyDestination());
        this._outboundQueue.enqueue(reply);
    }

    void sendAvailable() {
        block2: {
            try {
                this._outputStream.flushAvailable(this._receiver, false);
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(40)) break block2;
                this._log.error("Error flushing available", (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(PacketLocal packet) {
        if (packet == null) {
            return;
        }
        this.setNextSendTime(-1L);
        this._unackedPacketsReceived = 0;
        if (this._options.getRequireFullySigned()) {
            packet.setFlag(8);
            packet.setFlag(16);
        }
        boolean ackOnly = false;
        if (packet.getSequenceNum() == 0L && !packet.isFlagSet(1)) {
            ackOnly = true;
        } else {
            int remaining;
            int windowSize;
            Map<Long, PacketLocal> map = this._outboundPackets;
            synchronized (map) {
                this._outboundPackets.put(new Long(packet.getSequenceNum()), packet);
                windowSize = this._options.getWindowSize();
                remaining = windowSize - this._outboundPackets.size();
                this._outboundPackets.notifyAll();
            }
            if (packet.isFlagSet(2) || remaining < (windowSize + 2) / 3 || remaining < 3 || packet.getSequenceNum() % 8L == 0L) {
                packet.setOptionalDelay(0);
                packet.setFlag(64);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Requesting no ack delay for packet " + packet);
                }
            } else {
                int delay = this._options.getRTT() / 2;
                packet.setOptionalDelay(delay);
                if (delay > 0) {
                    packet.setFlag(64);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Requesting ack delay of " + delay + "ms for packet " + packet);
                }
            }
            packet.setFlag(64);
            long timeout = this._options.getRTO();
            if (timeout > 45000L) {
                timeout = 45000L;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Resend in " + timeout + " for " + packet);
            }
            ResendPacketEvent rpe = new ResendPacketEvent(packet, timeout);
        }
        this._lastSendTime = this._context.clock().now();
        this._outboundQueue.enqueue(packet);
        this.resetActivityTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PacketLocal> ackPackets(long ackThrough, long[] nacks) {
        if (ackThrough >= this._highestAckedThrough) {
            if (nacks == null) {
                this._highestAckedThrough = ackThrough;
            } else {
                long lowest = -1L;
                for (int i = 0; i < nacks.length; ++i) {
                    if (lowest >= 0L && nacks[i] >= lowest) continue;
                    lowest = nacks[i];
                }
                if (lowest - 1L > this._highestAckedThrough) {
                    this._highestAckedThrough = lowest - 1L;
                }
            }
        }
        ArrayList<PacketLocal> acked = null;
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            for (Long id : this._outboundPackets.keySet()) {
                if (id > ackThrough) break;
                boolean nacked = false;
                if (nacks != null) {
                    for (int i = 0; i < nacks.length; ++i) {
                        if (nacks[i] != id) continue;
                        nacked = true;
                        PacketLocal nackedPacket = this._outboundPackets.get(id);
                        nackedPacket.incrementNACKs();
                        break;
                    }
                }
                if (nacked) continue;
                if (acked == null) {
                    acked = new ArrayList<PacketLocal>(1);
                }
                PacketLocal ackedPacket = this._outboundPackets.get(id);
                ackedPacket.ackReceived();
                acked.add(ackedPacket);
            }
            if (acked != null) {
                for (int i = 0; i < acked.size(); ++i) {
                    PacketLocal p = (PacketLocal)acked.get(i);
                    this._outboundPackets.remove(new Long(p.getSequenceNum()));
                    ++this._ackedPackets;
                    if (p.getNumSends() <= 1) continue;
                    --this._activeResends;
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Active resend of " + p + " successful, # active left: " + this._activeResends);
                }
            }
            if (this._outboundPackets.isEmpty() && this._activeResends != 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("All outbound packets acked, clearing " + this._activeResends);
                }
                this._activeResends = 0;
            }
            this._outboundPackets.notifyAll();
        }
        if (acked != null && !acked.isEmpty()) {
            this._ackSinceCongestion = true;
        }
        return acked;
    }

    void eventOccurred() {
        long now = System.currentTimeMillis();
        TaskScheduler sched = this._chooser.getScheduler(this);
        if (this._occurredTime == (now -= now % 1000L)) {
            ++this._occurredEventCount;
        } else {
            this._occurredTime = now;
            if (this._occurredEventCount > 1000L && this._log.shouldLog(30)) {
                this._log.warn("More than 1000 events (" + this._occurredEventCount + ") in a second on " + this.toString() + ": scheduler = " + sched);
            }
            this._occurredEventCount = 0L;
        }
        long before = System.currentTimeMillis();
        sched.eventOccurred(this);
        long elapsed = System.currentTimeMillis() - before;
        if (elapsed > 1000L && this._log.shouldLog(30)) {
            this._log.warn("Took " + elapsed + "ms to pump through " + sched);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetReceived() {
        if (this._disconnectScheduledOn < 0L) {
            this._disconnectScheduledOn = this._context.clock().now();
            SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new DisconnectEvent(), 300000L);
        }
        this._resetReceived = true;
        MessageOutputStream mos = this._outputStream;
        MessageInputStream mis = this._inputStream;
        if (mos != null) {
            mos.streamErrorOccurred(new IOException("Reset received"));
        }
        if (mis != null) {
            mis.streamErrorOccurred(new IOException("Reset received"));
        }
        this._connectionError = "Connection reset";
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    public boolean getResetReceived() {
        return this._resetReceived;
    }

    public void setInbound() {
        this._isInbound = true;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean getIsConnected() {
        return this._connected;
    }

    public boolean getHardDisconnected() {
        return this._hardDisconnected;
    }

    public boolean getResetSent() {
        return this._resetSent;
    }

    public long getResetSentOn() {
        return this._resetSentOn;
    }

    public long getDisconnectScheduledOn() {
        return this._disconnectScheduledOn;
    }

    void disconnect(boolean cleanDisconnect) {
        this.disconnect(cleanDisconnect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(boolean cleanDisconnect, boolean removeFromConMgr) {
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Disconnecting " + this.toString(), (Throwable)new Exception("discon"));
        }
        if (!cleanDisconnect) {
            this._hardDisconnected = true;
            if (this._log.shouldLog(30)) {
                this._log.warn("Hard disconnecting and sending a reset on " + this.toString(), (Throwable)new Exception("cause"));
            }
            this.sendReset();
        }
        if (cleanDisconnect && this._connected) {
            this._outputStream.closeInternal();
            this._inputStream.close();
        } else {
            if (this._connected) {
                this.doClose();
            }
            this.killOutstandingPackets();
        }
        if (removeFromConMgr && this._disconnectScheduledOn < 0L) {
            this._disconnectScheduledOn = this._context.clock().now();
            SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new DisconnectEvent(), 300000L);
        }
        this._connected = false;
    }

    void disconnectComplete() {
        this._connected = false;
        if (this._socket != null) {
            this._socket.destroy();
        }
        this._socket = null;
        if (this._outputStream != null) {
            this._outputStream.destroy();
        }
        if (this._receiver != null) {
            this._receiver.destroy();
        }
        if (this._activityTimer != null) {
            this._activityTimer.cancel();
        }
        if (this._inputStream != null) {
            this._inputStream.streamErrorOccurred(new IOException("disconnected!"));
        }
        if (this._disconnectScheduledOn < 0L) {
            this._disconnectScheduledOn = this._context.clock().now();
            if (this._log.shouldLog(20)) {
                this._log.info("Connection disconnect complete from dead, drop the con " + this.toString());
            }
            this._connectionManager.removeConnection(this);
        }
        this.killOutstandingPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOutstandingPackets() {
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            for (PacketLocal pl : this._outboundPackets.values()) {
                pl.cancelled();
            }
            this._outboundPackets.clear();
            this._outboundPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        this._outputStream.streamErrorOccurred(new IOException("Hard disconnect"));
        this._inputStream.closeReceived();
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    public Destination getRemotePeer() {
        return this._remotePeer;
    }

    public void setRemotePeer(Destination peer) {
        if (this._remotePeerSet) {
            throw new RuntimeException("Remote peer already set [" + this._remotePeer + ", " + peer + "]");
        }
        this._remotePeerSet = true;
        this._remotePeer = peer;
        this._connectionManager.updateOptsFromShare(this);
    }

    public long getSendStreamId() {
        return this._sendStreamId;
    }

    public void setSendStreamId(long id) {
        if (this._sendStreamIdSet) {
            throw new RuntimeException("Send stream ID already set [" + this._sendStreamId + ", " + id + "]");
        }
        this._sendStreamIdSet = true;
        this._sendStreamId = id;
    }

    public long getReceiveStreamId() {
        return this._receiveStreamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveStreamId(long id) {
        if (this._receiveStreamIdSet) {
            throw new RuntimeException("Receive stream ID already set [" + this._receiveStreamId + ", " + id + "]");
        }
        this._receiveStreamIdSet = true;
        this._receiveStreamId = id;
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    public long getLastSendId() {
        return this._lastSendId.get();
    }

    public void setLastSendId(long id) {
        this._lastSendId.set(id);
    }

    public ConnectionOptions getOptions() {
        return this._options;
    }

    public void setOptions(ConnectionOptions opts) {
        this._options = opts;
    }

    public I2PSession getSession() {
        return this._connectionManager.getSession();
    }

    public I2PSocketFull getSocket() {
        return this._socket;
    }

    public void setSocket(I2PSocketFull socket) {
        this._socket = socket;
    }

    public String getConnectionError() {
        return this._connectionError;
    }

    public void setConnectionError(String err) {
        this._connectionError = err;
    }

    public long getLifetime() {
        if (this._closeSentOn <= 0L) {
            return this._context.clock().now() - this._createdOn;
        }
        return this._closeSentOn - this._createdOn;
    }

    public ConnectionPacketHandler getPacketHandler() {
        return this._handler;
    }

    public long getLifetimeBytesSent() {
        return this._lifetimeBytesSent;
    }

    public long getLifetimeBytesReceived() {
        return this._lifetimeBytesReceived;
    }

    public long getLifetimeDupMessagesSent() {
        return this._lifetimeDupMessageSent;
    }

    public long getLifetimeDupMessagesReceived() {
        return this._lifetimeDupMessageReceived;
    }

    public void incrementBytesSent(int bytes) {
        this._lifetimeBytesSent += (long)bytes;
    }

    public void incrementDupMessagesSent(int msgs) {
        this._lifetimeDupMessageSent += (long)msgs;
    }

    public void incrementBytesReceived(int bytes) {
        this._lifetimeBytesReceived += (long)bytes;
    }

    public void incrementDupMessagesReceived(int msgs) {
        this._lifetimeDupMessageReceived += (long)msgs;
    }

    public long getNextSendTime() {
        return this._nextSendTime;
    }

    public void setNextSendTime(long when) {
        long max;
        if (this._nextSendTime >= 0L) {
            if (when < this._nextSendTime) {
                this._nextSendTime = when;
            }
        } else {
            this._nextSendTime = when;
        }
        if (this._nextSendTime >= 0L && (max = this._context.clock().now() + (long)this._options.getSendAckDelay()) < this._nextSendTime) {
            this._nextSendTime = max;
        }
    }

    public long getAckedPackets() {
        return this._ackedPackets;
    }

    public long getCreatedOn() {
        return this._createdOn;
    }

    public long getCloseSentOn() {
        return this._closeSentOn;
    }

    public void setCloseSentOn(long when) {
        this._closeSentOn = when;
        if (this._disconnectScheduledOn < 0L) {
            this._disconnectScheduledOn = this._context.clock().now();
            SimpleScheduler.getInstance().addEvent((SimpleTimer.TimedEvent)new DisconnectEvent(), 300000L);
        }
    }

    public long getCloseReceivedOn() {
        return this._closeReceivedOn;
    }

    public void setCloseReceivedOn(long when) {
        this._closeReceivedOn = when;
    }

    public void updateShareOpts() {
        if (this._closeSentOn > 0L && !this._updatedShareOpts) {
            this._connectionManager.updateShareOpts(this);
            this._updatedShareOpts = true;
        }
    }

    public void incrementUnackedPacketsReceived() {
        ++this._unackedPacketsReceived;
    }

    public int getUnackedPacketsReceived() {
        return this._unackedPacketsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnackedPacketsSent() {
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            return this._outboundPackets.size();
        }
    }

    public long getCongestionWindowEnd() {
        return this._congestionWindowEnd;
    }

    public void setCongestionWindowEnd(long endMsg) {
        this._congestionWindowEnd = endMsg;
    }

    public long getHighestAckedThrough() {
        return this._highestAckedThrough;
    }

    public void setHighestAckedThrough(long msgNum) {
        this._highestAckedThrough = msgNum;
    }

    public long getLastActivityOn() {
        return this._lastSendTime > this._lastReceivedOn ? this._lastSendTime : this._lastReceivedOn;
    }

    public int getLastCongestionSeenAt() {
        return this._lastCongestionSeenAt;
    }

    void congestionOccurred() {
        if (this._ackSinceCongestion) {
            this._lastCongestionSeenAt = this._options.getWindowSize();
            this._lastCongestionTime = this._context.clock().now();
            this._lastCongestionHighestUnacked = this._lastSendId.get();
            this._ackSinceCongestion = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void packetReceived() {
        this._lastReceivedOn = this._context.clock().now();
        this.resetActivityTimer();
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForConnect() {
        long expiration = this._context.clock().now() + this._options.getConnectTimeout();
        while (true) {
            if (this._connected && this._receiveStreamId > 0L && this._sendStreamId > 0L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): Connected and we have stream IDs");
                }
                return;
            }
            if (this._connectionError != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): connection error found: " + this._connectionError);
                }
                return;
            }
            if (!this._connected) {
                this._connectionError = "Connection failed";
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): not connected");
                }
                return;
            }
            long timeLeft = expiration - this._context.clock().now();
            if (timeLeft <= 0L && this._options.getConnectTimeout() > 0L) {
                if (this._connectionError == null) {
                    this._connectionError = "Connection timed out";
                    this.disconnect(false);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): timed out: " + this._connectionError);
                }
                return;
            }
            if (timeLeft > 60000L) {
                timeLeft = 60000L;
            }
            if (this._options.getConnectTimeout() <= 0L) {
                timeLeft = 60000L;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("waitForConnect(): wait " + timeLeft);
            }
            try {
                Object object = this._connectLock;
                synchronized (object) {
                    this._connectLock.wait(timeLeft);
                }
            }
            catch (InterruptedException ie) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): InterruptedException");
                }
                this._connectionError = "InterruptedException";
                return;
            }
        }
    }

    private void resetActivityTimer() {
        if (this._options.getInactivityTimeout() <= 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Resetting the inactivity timer, but its gone!", (Throwable)new Exception("where did it go?"));
            }
            return;
        }
        if (this._activityTimer == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Resetting the inactivity timer, but its gone!", (Throwable)new Exception("where did it go?"));
            }
            return;
        }
        long howLong = this._options.getInactivityTimeout();
        this._activityTimer.reschedule(howLong += (long)this._randomWait, false);
    }

    public MessageInputStream getInputStream() {
        return this._inputStream;
    }

    public MessageOutputStream getOutputStream() {
        return this._outputStream;
    }

    public String toString() {
        long[] nacks;
        StringBuilder buf = new StringBuilder(128);
        buf.append("[Connection ");
        if (this._receiveStreamId > 0L) {
            buf.append(Packet.toId(this._receiveStreamId));
        } else {
            buf.append("unknown");
        }
        buf.append('/');
        if (this._sendStreamId > 0L) {
            buf.append(Packet.toId(this._sendStreamId));
        } else {
            buf.append("unknown");
        }
        if (this._isInbound) {
            buf.append(" from ");
        } else {
            buf.append(" to ");
        }
        if (this._remotePeerSet) {
            buf.append(this._remotePeer.calculateHash().toBase64().substring(0, 4));
        } else {
            buf.append("unknown");
        }
        buf.append(" up ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this._createdOn)));
        buf.append(" wsize: ").append(this._options.getWindowSize());
        buf.append(" cwin: ").append(this._congestionWindowEnd - this._highestAckedThrough);
        buf.append(" rtt: ").append(this._options.getRTT());
        buf.append(" rto: ").append(this._options.getRTO());
        buf.append(" unacked out: ").append(this._outboundPackets.size()).append(" ");
        buf.append("unacked in: ").append(this.getUnackedPacketsReceived());
        int missing = 0;
        if (this._inputStream != null && (nacks = this._inputStream.getNacks()) != null) {
            missing = nacks.length;
            buf.append(" [").append(missing).append(" missing]");
        }
        if (this.getResetSent()) {
            buf.append(" reset sent ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getResetSentOn()))).append(" ago");
        }
        if (this.getResetReceived()) {
            buf.append(" reset received ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getDisconnectScheduledOn()))).append(" ago");
        }
        if (this.getCloseSentOn() > 0L) {
            buf.append(" close sent ");
            long timeSinceClose = this._context.clock().now() - this.getCloseSentOn();
            buf.append(DataHelper.formatDuration((long)timeSinceClose));
            buf.append(" ago");
        }
        if (this.getCloseReceivedOn() > 0L) {
            buf.append(" close received ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getCloseReceivedOn()))).append(" ago");
        }
        buf.append(" sent: ").append(1L + this._lastSendId.get());
        if (this._inputStream != null) {
            buf.append(" rcvd: ").append(1L + this._inputStream.getHighestBlockId() - (long)missing);
        }
        buf.append(" maxWin ").append(this.getOptions().getMaxWindowSize());
        buf.append(" MTU ").append(this.getOptions().getMaxMessageSize());
        buf.append("]");
        return buf.toString();
    }

    public SimpleTimer.TimedEvent getConnectionEvent() {
        return this._connectionEvent;
    }

    class ResendPacketEvent
    extends SimpleTimer2.TimedEvent {
        private PacketLocal _packet;
        private long _nextSendTime;

        public ResendPacketEvent(PacketLocal packet, long delay) {
            super((SimpleTimer2)RetransmissionTimer.getInstance());
            this._packet = packet;
            this._nextSendTime = delay + Connection.this._context.clock().now();
            packet.setResendPacketEvent(this);
            this.schedule(delay);
        }

        public long getNextSendTime() {
            return this._nextSendTime;
        }

        public void timeReached() {
            this.retransmit(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retransmit(boolean penalize) {
            if (this._packet.getAckTime() > 0) {
                return false;
            }
            if (Connection.this._resetSent || Connection.this._resetReceived || !Connection.this._connected) {
                if (Connection.this._log.shouldLog(30) && !Connection.this._resetSent && !Connection.this._resetReceived) {
                    Connection.this._log.warn("??? no resets but not connected: " + this._packet);
                }
                this._packet.cancelled();
                return false;
            }
            boolean resend = false;
            boolean isLowest = false;
            Map map = Connection.this._outboundPackets;
            synchronized (map) {
                if (this._packet.getSequenceNum() == Connection.this._highestAckedThrough + 1L) {
                    isLowest = true;
                }
                if (Connection.this._outboundPackets.containsKey(new Long(this._packet.getSequenceNum()))) {
                    resend = true;
                }
            }
            if (resend && this._packet.getAckTime() <= 0) {
                int numSends;
                boolean fastRetransmit;
                boolean bl = fastRetransmit = this._packet.getNACKs() >= 2 && this._packet.getNumSends() == 1;
                if (!isLowest && !fastRetransmit) {
                    if (Connection.this._log.shouldLog(20)) {
                        Connection.this._log.info("Delaying resend of " + this._packet + " as there are " + Connection.this._activeResends + " active resends already in play");
                    }
                    this.forceReschedule(1000L);
                    this._nextSendTime = 1000L + Connection.this._context.clock().now();
                    return false;
                }
                if (fastRetransmit) {
                    Connection.this._context.statManager().addRateData("stream.fastRetransmit", this._packet.getLifetime(), this._packet.getLifetime());
                }
                Connection.this._inputStream.updateAcks(this._packet);
                int choke = Connection.this.getOptions().getChoke();
                this._packet.setOptionalDelay(choke);
                if (choke > 0) {
                    this._packet.setFlag(64);
                }
                this._packet.setOptionalMaxSize(Connection.this.getOptions().getMaxMessageSize());
                this._packet.setResendDelay(Connection.this.getOptions().getResendDelay() / 1000);
                if (this._packet.getReceiveStreamId() <= 0L) {
                    this._packet.setReceiveStreamId(Connection.this._receiveStreamId);
                }
                if (this._packet.getSendStreamId() <= 0L) {
                    this._packet.setSendStreamId(Connection.this._sendStreamId);
                }
                int newWindowSize = Connection.this.getOptions().getWindowSize();
                if (penalize && Connection.this._ackSinceCongestion && this._packet.getSequenceNum() > Connection.this._lastCongestionHighestUnacked) {
                    Connection.this.congestionOccurred();
                    Connection.this._context.statManager().addRateData("stream.con.windowSizeAtCongestion", (long)newWindowSize, this._packet.getLifetime());
                    if ((newWindowSize /= 2) <= 0) {
                        newWindowSize = 1;
                    }
                    Connection.this.getOptions().setWindowSize(newWindowSize);
                    if (Connection.this._log.shouldLog(30)) {
                        Connection.this._log.warn("Congestion resending packet " + this._packet.getSequenceNum() + ": new windowSize " + newWindowSize + "/" + Connection.this.getOptions().getWindowSize() + ") for " + Connection.this.toString());
                    }
                    Connection.this.windowAdjusted();
                }
                if ((numSends = this._packet.getNumSends() + 1) == 2) {
                    Connection.this._activeResends++;
                }
                if (numSends - 1 > Connection.this._options.getMaxResends()) {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug("Too many resends");
                    }
                    this._packet.cancelled();
                    Connection.this.disconnect(false);
                } else {
                    long timeout;
                    long rto = Connection.this._options.getRTO();
                    if (rto < 2000L) {
                        rto = 2000L;
                    }
                    if ((timeout = rto << numSends - 1) > 45000L || timeout <= 0L) {
                        timeout = 45000L;
                    }
                    this._nextSendTime = timeout + Connection.this._context.clock().now();
                    if (Connection.this._log.shouldLog(20)) {
                        Connection.this._log.info("Resend packet " + this._packet + " time " + numSends + " activeResends: " + Connection.this._activeResends + " (wsize " + newWindowSize + " lifetime " + (Connection.this._context.clock().now() - this._packet.getCreatedOn()) + "ms)");
                    }
                    Connection.this._outboundQueue.enqueue(this._packet);
                    Connection.this._lastSendTime = Connection.this._context.clock().now();
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug("Scheduling resend in " + timeout + "ms for " + this._packet);
                    }
                    this.forceReschedule(timeout);
                }
                if (this._packet.getAckTime() > 0 && this._packet.getNumSends() > 1) {
                    Connection.this._activeResends--;
                    Map map2 = Connection.this._outboundPackets;
                    synchronized (map2) {
                        Connection.this._outboundPackets.notifyAll();
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    class ConEvent
    implements SimpleTimer.TimedEvent {
        private Exception _addedBy;

        public void timeReached() {
            Connection.this.eventOccurred();
        }

        public String toString() {
            return "event on " + Connection.this.toString();
        }
    }

    private class ActivityTimer
    extends SimpleTimer2.TimedEvent {
        public ActivityTimer() {
            super((SimpleTimer2)RetransmissionTimer.getInstance());
            this.setFuzz(5000);
        }

        public void timeReached() {
            if (Connection.this._log.shouldLog(10)) {
                Connection.this._log.debug("Fire inactivity timer on " + Connection.this.toString());
            }
            if (!Connection.this._connected) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but we are already closed");
                }
                return;
            }
            long left = this.getTimeLeft();
            if (left > 0L) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there is time left (" + left + ")");
                }
                this.schedule(left);
                return;
            }
            if (Connection.this.getUnackedPacketsSent() > 0) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there are unacked packets");
                }
                return;
            }
            if (Connection.this._options.getInactivityTimeout() <= 0) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there is no timer...");
                }
                return;
            }
            if (Connection.this._log.shouldLog(10)) {
                Connection.this._log.debug("Inactivity timeout reached, with action=" + Connection.this._options.getInactivityAction());
            }
            switch (Connection.this._options.getInactivityAction()) {
                case 0: {
                    if (!Connection.this._log.shouldLog(30)) break;
                    Connection.this._log.warn("Inactivity timer expired, but we aint doin' shit");
                    break;
                }
                case 2: {
                    if (Connection.this._closeSentOn <= 0L && Connection.this._closeReceivedOn <= 0L) {
                        if (Connection.this._log.shouldLog(30)) {
                            Connection.this._log.warn("Sending some data due to inactivity");
                        }
                        Connection.this._receiver.send(null, 0, 0, true);
                        break;
                    }
                }
                default: {
                    if (Connection.this._log.shouldLog(30)) {
                        Connection.this._log.warn("Closing connection due to inactivity");
                    }
                    if (Connection.this._log.shouldLog(10)) {
                        StringBuilder buf = new StringBuilder(128);
                        buf.append("last sent was: ").append(Connection.this._context.clock().now() - Connection.this._lastSendTime);
                        buf.append("ms ago, last received was: ").append(Connection.this._context.clock().now() - Connection.this._lastReceivedOn);
                        buf.append("ms ago, inactivity timeout is: ").append(Connection.this._options.getInactivityTimeout());
                        Connection.this._log.debug(buf.toString());
                    }
                    Connection.this._inputStream.streamErrorOccurred(new IOException("Inactivity timeout"));
                    Connection.this._outputStream.streamErrorOccurred(new IOException("Inactivity timeout"));
                    Connection.this.disconnect(Connection.this._disconnectScheduledOn >= 0L);
                }
            }
        }

        public final long getTimeLeft() {
            if (Connection.this.getLastActivityOn() > 0L) {
                return Connection.this.getLastActivityOn() + (long)Connection.this._options.getInactivityTimeout() - Connection.this._context.clock().now();
            }
            return Connection.this._createdOn + (long)Connection.this._options.getInactivityTimeout() - Connection.this._context.clock().now();
        }
    }

    private class DisconnectEvent
    implements SimpleTimer.TimedEvent {
        public DisconnectEvent() {
            if (Connection.this._log.shouldLog(20)) {
                Connection.this._log.info("Connection disconnect timer initiated: 5 minutes to drop " + Connection.this.toString());
            }
        }

        public void timeReached() {
            Connection.this.killOutstandingPackets();
            if (Connection.this._log.shouldLog(20)) {
                Connection.this._log.info("Connection disconnect timer complete, drop the con " + Connection.this.toString());
            }
            Connection.this._connectionManager.removeConnection(Connection.this);
        }
    }
}

