/*
 * Decompiled with CFR 0.152.
 */
package phex.test;

import java.io.ByteArrayInputStream;
import java.io.PushbackInputStream;
import junit.framework.TestCase;
import phex.msg.GGEPBlock;

public class TestGGEPBlock
extends TestCase {
    private static final byte[] simpleGGEPBlock = new byte[]{-61, 2, 66, 72, 64, -125, 65, 76, 84, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public void testGGEPBlock() throws Exception {
        GGEPBlock[] gGEPBlockArray = GGEPBlock.parseGGEPBlocks((byte[])simpleGGEPBlock, (int)0);
        TestGGEPBlock.assertEquals((int)1, (int)gGEPBlockArray.length);
        TestGGEPBlock.assertTrue((boolean)gGEPBlockArray[0].isExtensionAvailable("BH"));
        TestGGEPBlock.assertEquals((int)gGEPBlockArray[0].getExtensionData("ALT").length, (int)9);
        gGEPBlockArray = GGEPBlock.parseGGEPBlocks((PushbackInputStream)new PushbackInputStream(new ByteArrayInputStream(simpleGGEPBlock)));
        TestGGEPBlock.assertEquals((int)1, (int)gGEPBlockArray.length);
        TestGGEPBlock.assertTrue((boolean)gGEPBlockArray[0].isExtensionAvailable("BH"));
        TestGGEPBlock.assertEquals((int)gGEPBlockArray[0].getExtensionData("ALT").length, (int)9);
        byte[] byArray = new byte[simpleGGEPBlock.length * 2];
        System.arraycopy(simpleGGEPBlock, 0, byArray, 0, simpleGGEPBlock.length);
        System.arraycopy(simpleGGEPBlock, 0, byArray, simpleGGEPBlock.length, simpleGGEPBlock.length);
        gGEPBlockArray = GGEPBlock.parseGGEPBlocks((byte[])byArray, (int)0);
        TestGGEPBlock.assertEquals((int)2, (int)gGEPBlockArray.length);
        TestGGEPBlock.assertTrue((boolean)gGEPBlockArray[0].isExtensionAvailable("BH"));
        TestGGEPBlock.assertEquals((int)gGEPBlockArray[0].getExtensionData("ALT").length, (int)9);
        TestGGEPBlock.assertTrue((boolean)gGEPBlockArray[1].isExtensionAvailable("BH"));
        TestGGEPBlock.assertEquals((int)gGEPBlockArray[1].getExtensionData("ALT").length, (int)9);
        gGEPBlockArray = GGEPBlock.parseGGEPBlocks((PushbackInputStream)new PushbackInputStream(new ByteArrayInputStream(byArray)));
        TestGGEPBlock.assertEquals((int)2, (int)gGEPBlockArray.length);
        TestGGEPBlock.assertTrue((boolean)gGEPBlockArray[0].isExtensionAvailable("BH"));
        TestGGEPBlock.assertEquals((int)gGEPBlockArray[0].getExtensionData("ALT").length, (int)9);
        TestGGEPBlock.assertTrue((boolean)gGEPBlockArray[1].isExtensionAvailable("BH"));
        TestGGEPBlock.assertEquals((int)gGEPBlockArray[1].getExtensionData("ALT").length, (int)9);
    }
}

