/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;

public class SimpleTimer2 {
    private static final SimpleTimer2 _instance = new SimpleTimer2();
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 4;
    private final I2PAppContext _context = I2PAppContext.getGlobalContext();
    private static Log _log;
    private final ScheduledThreadPoolExecutor _executor;
    private final String _name;
    private int _count;
    private final int _threads;

    public static SimpleTimer2 getInstance() {
        return _instance;
    }

    protected SimpleTimer2() {
        this("SimpleTimer2");
    }

    protected SimpleTimer2(String name) {
        _log = this._context.logManager().getLog(SimpleTimer2.class);
        this._name = name;
        this._count = 0;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x6000000L;
        }
        this._threads = (int)Math.max(2L, Math.min(4L, 1L + maxMemory / 0x2000000L));
        this._executor = new CustomScheduledThreadPoolExecutor(this._threads, new CustomThreadFactory());
        this._executor.prestartAllCoreThreads();
    }

    public void stop() {
        this._executor.shutdownNow();
    }

    private ScheduledFuture schedule(TimedEvent t, long timeoutMs) {
        return this._executor.schedule(t, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return this._name;
    }

    private long getCompletedTaskCount() {
        return this._executor.getCompletedTaskCount();
    }

    private String debug() {
        this._executor.purge();
        return " Pool: " + this._name + " Active: " + this._executor.getActiveCount() + '/' + this._executor.getPoolSize() + " Completed: " + this._executor.getCompletedTaskCount() + " Queued: " + this._executor.getQueue().size();
    }

    public static abstract class TimedEvent
    implements Runnable {
        private SimpleTimer2 _pool;
        private int _fuzz;
        protected static final int DEFAULT_FUZZ = 3;
        private ScheduledFuture _future;

        public TimedEvent(SimpleTimer2 pool) {
            this._pool = pool;
            this._fuzz = 3;
        }

        public TimedEvent(SimpleTimer2 pool, long timeoutMs) {
            this(pool);
            this.schedule(timeoutMs);
        }

        public void setFuzz(int fuzz) {
            this._fuzz = fuzz;
        }

        public synchronized void schedule(long timeoutMs) {
            if (_log.shouldLog(10)) {
                _log.debug("Scheduling: " + this + " timeout = " + timeoutMs);
            }
            if (timeoutMs <= 0L && _log.shouldLog(30)) {
                timeoutMs = 1L;
            }
            this._future = this._pool.schedule(this, timeoutMs);
        }

        public void reschedule(long timeoutMs) {
            this.reschedule(timeoutMs, true);
        }

        public synchronized void reschedule(long timeoutMs, boolean useEarliestTime) {
            boolean scheduled = this._future != null && !this._future.isDone();
            long oldTimeout = scheduled ? this._future.getDelay(TimeUnit.MILLISECONDS) : timeoutMs;
            if (oldTimeout - (long)this._fuzz > timeoutMs && useEarliestTime || oldTimeout + (long)this._fuzz < timeoutMs && !useEarliestTime || !scheduled) {
                if (scheduled) {
                    if (_log.shouldLog(20)) {
                        _log.info("Re-scheduling: " + this + " timeout = " + timeoutMs + " old timeout was " + oldTimeout);
                    }
                    this.cancel();
                }
                this.schedule(timeoutMs);
            }
        }

        public synchronized void forceReschedule(long timeoutMs) {
            this.cancel();
            this.schedule(timeoutMs);
        }

        public synchronized boolean cancel() {
            if (this._future == null) {
                return false;
            }
            return this._future.cancel(false);
        }

        public void run() {
            if (_log.shouldLog(10)) {
                _log.debug("Running: " + this);
            }
            long before = System.currentTimeMillis();
            long delay = 0L;
            if (this._future != null) {
                delay = this._future.getDelay(TimeUnit.MILLISECONDS);
            } else if (_log.shouldLog(30)) {
                _log.warn(this._pool + " wtf, no _future " + this);
            }
            if (_log.shouldLog(30) && delay > 100L) {
                _log.warn(this._pool + " wtf, early execution " + delay + ": " + this);
            } else if (_log.shouldLog(30) && delay < -1000L) {
                _log.warn(" wtf, late execution " + delay + ": " + this + this._pool.debug());
            }
            try {
                this.timeReached();
            }
            catch (Throwable t) {
                _log.log(50, this._pool + ": Timed task " + this + " exited unexpectedly, please report", t);
            }
            long time = System.currentTimeMillis() - before;
            if (time > 500L && _log.shouldLog(30)) {
                _log.warn(this._pool + " wtf, event execution took " + time + ": " + this);
            }
            long completed = this._pool.getCompletedTaskCount();
            if (_log.shouldLog(20) && completed % 250L == 0L) {
                _log.info(this._pool.debug());
            }
        }

        public abstract void timeReached();
    }

    private class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName(SimpleTimer2.this._name + ' ' + ++SimpleTimer2.this._count + '/' + SimpleTimer2.this._threads);
            rv.setDaemon(true);
            return rv;
        }
    }

    private static class CustomScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        public CustomScheduledThreadPoolExecutor(int threads, ThreadFactory factory) {
            super(threads, factory);
        }

        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                _log.log(50, "wtf, event borked: " + r, t);
            }
        }
    }
}

