/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.EepGet;
import net.i2p.util.SocketTimeout;

public class SSLEepGet
extends EepGet {
    private boolean _saveCerts;
    private boolean _commandLine;
    private final SSLContext _sslContext;
    private SavingTrustManager _stm;
    private static final int LINE_LENGTH = 64;

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url) {
        this(ctx, outputStream, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url, SSLState state) {
        super(ctx, false, null, -1, 0, -1L, -1L, null, outputStream, url, true, null, null);
        this._sslContext = state != null && state.context != null ? state.context : this.initSSLContext();
        if (this._sslContext == null) {
            this._log.error("Failed to initialize custom SSL context, using default context");
        }
    }

    public static void main(String[] args) {
        FileOutputStream out;
        String url = null;
        boolean saveCerts = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-s")) {
                    saveCerts = true;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    SSLEepGet.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SSLEepGet.usage();
            return;
        }
        if (url == null) {
            SSLEepGet.usage();
            return;
        }
        String saveAs = SSLEepGet.suggestName(url);
        try {
            out = new FileOutputStream(saveAs);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create output file " + saveAs);
            return;
        }
        SSLEepGet get = new SSLEepGet(I2PAppContext.getGlobalContext(), out, url);
        if (saveCerts) {
            get._saveCerts = true;
        }
        get._commandLine = true;
        SSLEepGet sSLEepGet = get;
        sSLEepGet.getClass();
        get.addStatusListener(sSLEepGet.new EepGet.CLIStatusListener(1024, 40));
        get.fetch(45000L, -1L, 60000L);
    }

    private static void usage() {
        System.err.println("Usage: SSLEepGet https://url");
        System.err.println("To save unknown certs, use: SSLEepGet -s https://url");
    }

    private SSLContext initSSLContext() {
        int adds;
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Key Store init error", gse);
            return null;
        }
        boolean success = false;
        String override = System.getProperty("javax.net.ssl.keyStore");
        if (override != null) {
            success = this.loadCerts(new File(override), ks);
        }
        if (!success) {
            success = this.loadCerts(new File(System.getProperty("java.home"), "lib/security/jssecacerts"), ks);
        }
        if (!success) {
            success = this.loadCerts(new File(System.getProperty("java.home"), "lib/security/cacerts"), ks);
        }
        if (!success) {
            this._log.error("All key store loads failed, will only load local certificates");
        } else if (this._log.shouldLog(20)) {
            int count = 0;
            try {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    if (!ks.isCertificateEntry(alias)) continue;
                    ++count;
                }
            }
            catch (Exception foo) {
                // empty catch block
            }
            this._log.info("Loaded " + count + " default trusted certificates");
        }
        File dir = new File(this._context.getBaseDir(), "certificates");
        int totalAdds = adds = this.addCerts(dir, ks);
        if (adds > 0 && this._log.shouldLog(20)) {
            this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
        }
        if (!this._context.getBaseDir().getAbsolutePath().equals(this._context.getConfigDir().getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), "certificates");
            adds = this.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        dir = new File(System.getProperty("user.dir"));
        if (!this._context.getBaseDir().getAbsolutePath().equals(dir.getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), "certificates");
            adds = this.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Loaded total of " + totalAdds + " new trusted certificates");
        }
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            this._stm = new SavingTrustManager(defaultTrustManager);
            sslc.init(null, new TrustManager[]{this._stm}, null);
            return sslc;
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Key Store update error", gse);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCerts(File file, KeyStore ks) {
        if (!file.exists()) {
            return false;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ks.load(fis, "changeit".toCharArray());
        }
        catch (GeneralSecurityException gse) {
            this._log.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), gse);
            try {
                ks.load(null, "changeit".toCharArray());
            }
            catch (Exception foo) {
                // empty catch block
            }
            boolean foo = false;
            return foo;
        }
        catch (IOException ioe) {
            this._log.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), ioe);
            try {
                ks.load(null, "changeit".toCharArray());
            }
            catch (Exception foo) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException foo) {}
        }
        return true;
    }

    private int addCerts(File dir, KeyStore ks) {
        File[] files;
        if (this._log.shouldLog(20)) {
            this._log.info("Looking for X509 Certificates in " + dir.getAbsolutePath());
        }
        int added = 0;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean success;
                File f = files[i];
                if (!f.isFile()) continue;
                String alias = f.getName().toLowerCase();
                if (alias.endsWith(".crt") || alias.endsWith(".pem") || alias.endsWith(".key") || alias.endsWith(".der") || alias.endsWith(".key") || alias.endsWith(".p7b") || alias.endsWith(".p7c") || alias.endsWith(".pfx") || alias.endsWith(".p12")) {
                    alias = alias.substring(0, alias.length() - 4);
                }
                if (!(success = this.addCert(f, alias, ks))) continue;
                ++added;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean addCert(File file, String alias, KeyStore ks) {
        block29: {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
                if (this._log.shouldLog(20)) {
                    this._log.info("Read X509 Certificate from " + file.getAbsolutePath() + " Issuer: " + cert.getIssuerX500Principal() + "; Valid From: " + cert.getNotBefore() + " To: " + cert.getNotAfter());
                }
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException cee) {
                    this._log.error("Rejecting expired X509 Certificate: " + file.getAbsolutePath(), cee);
                    boolean bl = false;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (CertificateNotYetValidException cnyve) {
                    this._log.error("Rejecting X509 Certificate not yet valid: " + file.getAbsolutePath(), cnyve);
                    boolean bl = false;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
                ks.setCertificateEntry(alias, cert);
                if (this._log.shouldLog(20)) {
                    this._log.info("Now trusting X509 Certificate, Issuer: " + cert.getIssuerX500Principal());
                }
                break block29;
                {
                    catch (GeneralSecurityException gse) {
                        this._log.error("Error reading X509 Certificate: " + file.getAbsolutePath(), gse);
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException ioe) {
                        this._log.error("Error reading X509 Certificate: " + file.getAbsolutePath(), ioe);
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            finally {
                try {
                    if (fis != null) {
                        ((InputStream)fis).close();
                    }
                }
                catch (IOException foo) {}
            }
        }
        return true;
    }

    private static void saveCerts(String host, SavingTrustManager stm) {
        X509Certificate[] chain = stm.chain;
        if (chain == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        for (int k = 0; k < chain.length; ++k) {
            X509Certificate cert = chain[k];
            String name = host + '-' + (k + 1) + ".crt";
            System.out.println("NOTE: Saving untrusted X509 certificate as " + name);
            System.out.println("      Issuer:     " + cert.getIssuerX500Principal());
            System.out.println("      Valid From: " + cert.getNotBefore());
            System.out.println("      Valid To:   " + cert.getNotAfter());
            try {
                cert.checkValidity();
            }
            catch (Exception e) {
                System.out.println("      WARNING: Certificate is not currently valid, it cannot be used");
            }
            SSLEepGet.saveCert(cert, new File(name));
        }
        System.out.println("NOTE: To trust them, copy the certificate file(s) to the certificates directory and rerun without the -s option");
        System.out.println("NOTE: EepGet failed, certificate error follows:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCert(Certificate cert, File file) {
        OutputStream os = null;
        try {
            byte[] buf = cert.getEncoded();
            os = new FileOutputStream(file);
            PrintWriter wr = new PrintWriter(os);
            wr.println("-----BEGIN CERTIFICATE-----");
            String b64 = Base64.encode(buf, true);
            for (int i = 0; i < b64.length(); i += 64) {
                wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
            }
            wr.println("-----END CERTIFICATE-----");
            wr.flush();
        }
        catch (CertificateEncodingException cee) {
            System.out.println("Error writing X509 Certificate " + file.getAbsolutePath() + ' ' + cee);
        }
        catch (IOException ioe) {
            System.out.println("Error writing X509 Certificate " + file.getAbsolutePath() + ' ' + ioe);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException foo) {}
        }
    }

    public SSLState getSSLState() {
        return new SSLState(this._sslContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetch(SocketTimeout timeout) throws IOException {
        int i;
        this._headersRead = false;
        this._aborted = false;
        try {
            this.readHeaders();
        }
        finally {
            this._headersRead = true;
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        if (timeout != null) {
            timeout.resetTimer();
            if (this._fetchInactivityTimeout > 0L) {
                timeout.setInactivityTimeout(this._fetchInactivityTimeout);
            } else {
                timeout.setInactivityTimeout(60000L);
            }
        }
        if (this._redirectLocation != null) {
            throw new IOException("Server redirect to " + this._redirectLocation + " not allowed");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely, reading " + this._bytesRemaining);
        }
        boolean strictSize = this._bytesRemaining >= 0L;
        int remaining = (int)this._bytesRemaining;
        byte[] buf = new byte[1024];
        while (!(!this._keepFetching || remaining <= 0 && strictSize || this._aborted)) {
            int read;
            int toRead = buf.length;
            if (strictSize && toRead > remaining) {
                toRead = remaining;
            }
            if ((read = this._proxyIn.read(buf, 0, toRead)) == -1) break;
            if (timeout != null) {
                timeout.resetTimer();
            }
            this._out.write(buf, 0, read);
            this._bytesTransferred += (long)read;
            if ((remaining -= read) == 0 && this._encodingChunked) {
                int char1 = this._proxyIn.read();
                if (char1 == 13) {
                    int char2 = this._proxyIn.read();
                    if (char2 == 10) {
                        remaining = (int)this.readChunkLength();
                    } else {
                        this._out.write(char1);
                        this._out.write(char2);
                        this._bytesTransferred += 2L;
                        remaining -= 2;
                        read += 2;
                    }
                } else {
                    this._out.write(char1);
                    ++this._bytesTransferred;
                    --remaining;
                    ++read;
                }
            }
            if (timeout != null) {
                timeout.resetTimer();
            }
            if (this._bytesRemaining >= (long)read) {
                this._bytesRemaining -= (long)read;
            }
            if (read <= 0) continue;
            for (int i2 = 0; i2 < this._listeners.size(); ++i2) {
                ((EepGet.StatusListener)this._listeners.get(i2)).bytesTransferred(this._alreadyTransferred, read, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url);
            }
            this._alreadyTransferred += (long)read;
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        if (timeout != null) {
            timeout.cancel();
        }
        if (this._transferFailed) {
            for (i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else if (this._bytesRemaining == -1L || remaining == 0) {
            for (i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(this._alreadyTransferred, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url, this._outputFile, this._notModified);
            }
        } else {
            throw new IOException("Disconnection on attempt " + this._currentAttempt + " after " + this._bytesTransferred);
        }
    }

    protected void sendRequest(SocketTimeout timeout) throws IOException {
        File outFile;
        if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
            this._alreadyTransferred = outFile.length();
        }
        String req = this.getRequest();
        URL url = new URL(this._actualURL);
        String host = null;
        int port = 0;
        if ("https".equals(url.getProtocol())) {
            host = url.getHost();
            port = url.getPort();
            if (port == -1) {
                port = 443;
            }
            this._proxy = this._sslContext != null ? this._sslContext.getSocketFactory().createSocket(host, port) : SSLSocketFactory.getDefault().createSocket(host, port);
        } else {
            throw new IOException("Only https supported: " + this._actualURL);
        }
        this._proxyIn = this._proxy.getInputStream();
        this._proxyOut = this._proxy.getOutputStream();
        try {
            this._proxyOut.write(DataHelper.getUTF8(req));
            this._proxyOut.flush();
        }
        catch (SSLHandshakeException sslhe) {
            this._log.error("SSL negotiation error with " + host + ':' + port + " - self-signed certificate or untrusted certificate authority?", sslhe);
            if (this._saveCerts && this._stm != null) {
                SSLEepGet.saveCerts(host, this._stm);
            } else if (this._commandLine) {
                System.out.println("FAILED (probably due to untrusted certificates) - Run with -s option to save certificates");
            }
            throw sslhe;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Request flushed");
        }
    }

    public static class SSLState {
        private SSLContext context;

        private SSLState(SSLContext ctx) {
            this.context = ctx;
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

