/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EntropyHarvester;
import net.i2p.data.Base64;
import net.i2p.util.SecureFileOutputStream;

public class RandomSource
extends SecureRandom
implements EntropyHarvester {
    private final EntropyHarvester _entropyHarvester;
    protected final I2PAppContext _context;
    private static final String SEEDFILE = "prngseed.rnd";

    public RandomSource(I2PAppContext context) {
        this._context = context;
        this._entropyHarvester = this;
    }

    public static RandomSource getInstance() {
        return I2PAppContext.getGlobalContext().random();
    }

    public int nextInt(int n) {
        if (n == 0) {
            return 0;
        }
        int val = super.nextInt(n);
        if (val < 0) {
            val = 0 - val;
        }
        if (val >= n) {
            val %= n;
        }
        return val;
    }

    public long nextLong(long n) {
        long v = super.nextLong();
        if (v < 0L) {
            v = 0L - v;
        }
        if (v >= n) {
            v %= n;
        }
        return v;
    }

    public EntropyHarvester harvester() {
        return this._entropyHarvester;
    }

    public void feedEntropy(String source, long data, int bitoffset, int bits) {
        if (bitoffset == 0) {
            this.setSeed(data);
        }
    }

    public void feedEntropy(String source, byte[] data, int offset, int len) {
        if (offset == 0 && len == data.length) {
            this.setSeed(data);
        } else {
            this.setSeed(this._context.sha().calculateHash(data, offset, len).getData());
        }
    }

    public void loadSeed() {
        byte[] buf = new byte[1024];
        if (this.initSeed(buf)) {
            this.setSeed(buf);
        }
    }

    public void saveSeed() {
        byte[] buf = new byte[1024];
        this.nextBytes(buf);
        RandomSource.writeSeed(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeSeed(byte[] buf) {
        File f = new File(I2PAppContext.getGlobalContext().getConfigDir(), SEEDFILE);
        SecureFileOutputStream fos = null;
        try {
            fos = new SecureFileOutputStream(f);
            fos.write(buf);
        }
        catch (IOException ioe) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public final boolean initSeed(byte[] buf) {
        boolean ok = RandomSource.seedFromFile(new File("/dev/urandom"), buf);
        File localFile = new File(this._context.getConfigDir(), SEEDFILE);
        ok = RandomSource.seedFromFile(localFile, buf) || ok;
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean seedFromFile(File f, byte[] buf) {
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                int read;
                int curRead;
                fis = new FileInputStream(f);
                byte[] tbuf = new byte[buf.length];
                for (read = 0; read < buf.length && (curRead = fis.read(tbuf, read, tbuf.length - read)) >= 0; read += curRead) {
                }
                for (int i = 0; i < read; ++i) {
                    int n = i;
                    buf[n] = (byte)(buf[n] ^ tbuf[i]);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException ioe) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        for (int j = 0; j < 2; ++j) {
            RandomSource rs = new RandomSource(I2PAppContext.getGlobalContext());
            byte[] buf = new byte[1024];
            boolean seeded = rs.initSeed(buf);
            System.out.println("PRNG class hierarchy: ");
            for (Class<?> c = rs.getClass(); c != null; c = c.getSuperclass()) {
                System.out.println("\t" + c.getName());
            }
            System.out.println("Provider: \n" + rs.getProvider());
            if (seeded) {
                System.out.println("Initialized seed: " + Base64.encode(buf));
                rs.setSeed(buf);
            }
            for (int i = 0; i < 64; ++i) {
                rs.nextBytes(buf);
            }
            rs.saveSeed();
        }
    }

    private static class DummyEntropyHarvester
    implements EntropyHarvester {
        private DummyEntropyHarvester() {
        }

        public void feedEntropy(String source, long data, int bitoffset, int bits) {
        }

        public void feedEntropy(String source, byte[] data, int offset, int len) {
        }
    }
}

