/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.i2p.util.Log;

public class I2PThread
extends Thread {
    private static volatile Log _log;
    private static final Set _listeners;
    private String _name;
    private Exception _createdBy;

    public I2PThread() {
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(String name) {
        super(name);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(Runnable r) {
        super(r);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(Runnable r, String name) {
        super(r, name);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(Runnable r, String name, boolean isDaemon) {
        super(r, name);
        this.setDaemon(isDaemon);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    public I2PThread(ThreadGroup g, Runnable r) {
        super(g, r);
        if (_log == null || _log.shouldLog(10)) {
            this._createdBy = new Exception("Created by");
        }
    }

    private static void log(int level, String msg) {
        I2PThread.log(level, msg, null);
    }

    private static void log(int level, String msg, Throwable t) {
        if (_log == null) {
            _log = new Log(I2PThread.class);
        }
        if (_log.shouldLog(level)) {
            _log.log(level, msg, t);
        }
    }

    public void run() {
        block4: {
            this._name = Thread.currentThread().getName();
            I2PThread.log(20, "New thread started" + (this.isDaemon() ? " (daemon): " : ": ") + this._name, this._createdBy);
            try {
                super.run();
            }
            catch (Throwable t) {
                try {
                    I2PThread.log(50, "Thread terminated unexpectedly: " + this.getName(), t);
                }
                catch (Throwable woof) {
                    System.err.println("Died within the OOM itself");
                    t.printStackTrace();
                }
                if (!(t instanceof OutOfMemoryError)) break block4;
                this.fireOOM((OutOfMemoryError)t);
            }
        }
        I2PThread.log(20, "Thread finished normally: " + this._name);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void fireOOM(OutOfMemoryError oom) {
        for (OOMEventListener listener : _listeners) {
            listener.outOfMemory(oom);
        }
    }

    public static void addOOMEventListener(OOMEventListener lsnr) {
        _listeners.add(lsnr);
    }

    public static void removeOOMEventListener(OOMEventListener lsnr) {
        _listeners.remove(lsnr);
    }

    public static void main(String[] args) {
        I2PThread t = new I2PThread(new Runnable(){

            public void run() {
                throw new NullPointerException("blah");
            }
        });
        t.start();
        try {
            Thread.sleep(10000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        _listeners = new CopyOnWriteArraySet();
    }

    public static interface OOMEventListener {
        public void outOfMemory(OutOfMemoryError var1);
    }
}

