/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    private static boolean _failedOracle;
    private static boolean _failedApache;

    public static final boolean rmdir(String path, boolean failIfNotEmpty) {
        return FileUtil.rmdir(new File(path), failIfNotEmpty);
    }

    public static final boolean rmdir(File target, boolean failIfNotEmpty) {
        if (!target.exists()) {
            return true;
        }
        if (!target.isDirectory()) {
            return target.delete();
        }
        File[] children = target.listFiles();
        if (children == null) {
            return false;
        }
        if (failIfNotEmpty && children.length > 0) {
            return false;
        }
        for (int i = 0; i < children.length; ++i) {
            if (FileUtil.rmdir(children[i], failIfNotEmpty)) continue;
            return false;
        }
        return target.delete();
    }

    /*
     * Exception decompiling
     */
    public static boolean extractZip(File zipfile, File targetDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyZip(File zipfile) {
        ZipFile zip = null;
        try {
            byte[] buf = new byte[16384];
            zip = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            boolean p200TestRequired = true;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().indexOf("..") != -1) {
                    boolean bl = false;
                    return bl;
                }
                if (entry.isDirectory()) continue;
                if (p200TestRequired && (entry.getName().endsWith(".jar.pack") || entry.getName().endsWith(".war.pack"))) {
                    if (!FileUtil.isPack200Supported()) {
                        System.err.println("ERROR: Zip verify failed, your JVM does not support unpack200");
                        boolean bl = false;
                        return bl;
                    }
                    p200TestRequired = false;
                }
                try {
                    InputStream in = zip.getInputStream(entry);
                    int read = 0;
                    while ((read = in.read(buf)) != -1) {
                    }
                    in.close();
                }
                catch (IOException ioe) {
                    boolean bl = false;
                    if (zip == null) return bl;
                    try {
                        zip.close();
                        return bl;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static boolean isPack200Supported() {
        try {
            Class.forName("java.util.jar.Pack200", false, ClassLoader.getSystemClassLoader());
            return true;
        }
        catch (Exception e) {
            try {
                Class.forName("org.apache.harmony.unpack200.Archive", false, ClassLoader.getSystemClassLoader());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static void unpack(InputStream in, JarOutputStream out) throws Exception {
        if (!_failedOracle) {
            try {
                Class<?> p200 = Class.forName("java.util.jar.Pack200", true, ClassLoader.getSystemClassLoader());
                Method newUnpacker = p200.getMethod("newUnpacker", null);
                Object unpacker = newUnpacker.invoke(null, (Object[])null);
                Method unpack = unpacker.getClass().getMethod("unpack", InputStream.class, JarOutputStream.class);
                unpack.invoke(unpacker, in, out);
                return;
            }
            catch (ClassNotFoundException e) {
                _failedOracle = true;
            }
            catch (NoSuchMethodException e) {
                _failedOracle = true;
            }
        }
        if (!_failedApache) {
            try {
                Class<?> p200 = Class.forName("org.apache.harmony.unpack200.Archive", true, ClassLoader.getSystemClassLoader());
                Constructor<?> newUnpacker = p200.getConstructor(InputStream.class, JarOutputStream.class);
                Object unpacker = newUnpacker.newInstance(in, out);
                Method unpack = unpacker.getClass().getMethod("unpack", null);
                unpack.invoke(unpacker, (Object[])null);
                return;
            }
            catch (ClassNotFoundException e) {
                _failedApache = true;
            }
            catch (NoSuchMethodException e) {
                _failedApache = true;
            }
        }
        throw new IOException("Unpack200 not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String filename, int maxNumLines, boolean startAtBeginning) {
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            ArrayList<String> lines = new ArrayList<String>(maxNumLines > 0 ? maxNumLines : 64);
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
                if (maxNumLines <= 0 || lines.size() < maxNumLines) continue;
                if (startAtBeginning) break;
                lines.remove(0);
            }
            StringBuilder buf = new StringBuilder(lines.size() * 80);
            for (int i = 0; i < lines.size(); ++i) {
                buf.append((String)lines.get(i)).append('\n');
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(String path, String root, OutputStream out) throws IOException {
        String rootDirStr;
        File rootDir = new File(root);
        while (path.startsWith("/") && path.length() > 0) {
            path = path.substring(1);
        }
        if (path.length() <= 0) {
            throw new FileNotFoundException("Not serving up the root dir");
        }
        File target = new File(rootDir, path);
        if (!target.exists()) {
            throw new FileNotFoundException("Requested file does not exist: " + path);
        }
        String targetStr = target.getCanonicalPath();
        if (!targetStr.startsWith(rootDirStr = rootDir.getCanonicalPath())) {
            throw new FileNotFoundException("Requested file is outside the root dir: " + path);
        }
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        try {
            in = new FileInputStream(target);
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static boolean copy(String source, String dest, boolean overwriteExisting) {
        return FileUtil.copy(source, dest, overwriteExisting, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(String source, String dest, boolean overwriteExisting, boolean quiet) {
        File src = new File(source);
        File dst = new File(dest);
        if (dst.exists() && dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        if (!src.exists()) {
            return false;
        }
        if (dst.exists() && !overwriteExisting) {
            return false;
        }
        byte[] buf = new byte[4096];
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            int read = 0;
            while ((read = ((InputStream)in).read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, read);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (!quiet) {
                ioe.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.err.println("Usage: delete path | copy source dest | unzip path.zip");
        } else if ("delete".equals(args[0])) {
            boolean deleted = FileUtil.rmdir(args[1], false);
            if (!deleted) {
                System.err.println("Error deleting [" + args[1] + "]");
            }
        } else if ("copy".equals(args[0])) {
            boolean copied = FileUtil.copy(args[1], args[2], false);
            if (!copied) {
                System.err.println("Error copying [" + args[1] + "] to [" + args[2] + "]");
            }
        } else if ("unzip".equals(args[0])) {
            File f = new File(args[1]);
            File to = new File("tmp");
            to.mkdir();
            boolean copied = FileUtil.verifyZip(f);
            if (!copied) {
                System.err.println("Error verifying " + args[1]);
            }
            if (copied = FileUtil.extractZip(f, to)) {
                System.err.println("Unzipped [" + args[1] + "] to [" + to + "]");
            } else {
                System.err.println("Error unzipping [" + args[1] + "] to [" + to + "]");
            }
        }
    }
}

