/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import net.i2p.util.EventDispatcher;

public class EventDispatcherImpl
implements EventDispatcher {
    private boolean _ignore = false;
    private final HashMap _events = new HashMap(4);
    private final ArrayList _attached = new ArrayList();

    public EventDispatcher getEventDispatcher() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachEventDispatcher(EventDispatcher ev) {
        if (ev == null) {
            return;
        }
        ArrayList arrayList = this._attached;
        synchronized (arrayList) {
            this._attached.add(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachEventDispatcher(EventDispatcher ev) {
        if (ev == null) {
            return;
        }
        ArrayList arrayList = this._attached;
        synchronized (arrayList) {
            ListIterator it = this._attached.listIterator();
            while (it.hasNext()) {
                if ((EventDispatcher)it.next() != ev) continue;
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(String eventName, Object args) {
        if (this._ignore) {
            return;
        }
        if (args == null) {
            args = "[null value]";
        }
        HashMap hashMap = this._events;
        synchronized (hashMap) {
            this._events.put(eventName, args);
            this._events.notifyAll();
            ArrayList arrayList = this._attached;
            synchronized (arrayList) {
                for (EventDispatcher e : this._attached) {
                    e.notifyEvent(eventName, args);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEventValue(String name) {
        Object val;
        if (this._ignore) {
            return null;
        }
        HashMap hashMap = this._events;
        synchronized (hashMap) {
            val = this._events.get(name);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getEvents() {
        HashSet set;
        if (this._ignore) {
            return Collections.EMPTY_SET;
        }
        HashMap hashMap = this._events;
        synchronized (hashMap) {
            set = new HashSet(this._events.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreEvents() {
        this._ignore = true;
        HashMap hashMap = this._events;
        synchronized (hashMap) {
            this._events.clear();
        }
    }

    public void unIgnoreEvents() {
        this._ignore = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitEventValue(String name) {
        Object val;
        if (this._ignore) {
            return null;
        }
        while (true) {
            HashMap hashMap = this._events;
            synchronized (hashMap) {
                if (this._events.containsKey(name)) {
                    val = this._events.get(name);
                    break;
                }
                try {
                    this._events.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return val;
    }
}

