/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import org.xlattice.crypto.filters.BloomSHA1;

public class DecayingBloomFilter {
    protected final I2PAppContext _context;
    protected final Log _log;
    private BloomSHA1 _current;
    private BloomSHA1 _previous;
    protected final int _durationMs;
    protected final int _entryBytes;
    private byte[][] _extenders;
    private byte[] _extended;
    private byte[] _longToEntry;
    private long _longToEntryMask;
    protected long _currentDuplicates;
    protected volatile boolean _keepDecaying;
    protected SimpleTimer.TimedEvent _decayEvent;
    protected final String _name;
    private static final int DEFAULT_M = 23;
    private static final int DEFAULT_K = 11;
    private static final boolean ALWAYS_MISS = false;

    protected DecayingBloomFilter(int durationMs, int entryBytes, String name, I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._entryBytes = entryBytes;
        this._name = name;
        this._durationMs = durationMs;
    }

    public DecayingBloomFilter(I2PAppContext context, int durationMs, int entryBytes) {
        this(context, durationMs, entryBytes, "DBF");
    }

    public DecayingBloomFilter(I2PAppContext context, int durationMs, int entryBytes, String name) {
        this(context, durationMs, entryBytes, name, context.getProperty("router.decayingBloomFilterM", 23));
    }

    public DecayingBloomFilter(I2PAppContext context, int durationMs, int entryBytes, String name, int m) {
        this._context = context;
        this._log = context.logManager().getLog(DecayingBloomFilter.class);
        this._entryBytes = entryBytes;
        this._name = name;
        int k = 11;
        if (m > 23) {
            --k;
        }
        this._current = new BloomSHA1(m, k);
        this._previous = new BloomSHA1(m, k);
        this._durationMs = durationMs;
        int numExtenders = (32 + (entryBytes - 1)) / entryBytes - 1;
        if (numExtenders < 0) {
            numExtenders = 0;
        }
        this._extenders = new byte[numExtenders][entryBytes];
        for (int i = 0; i < numExtenders; ++i) {
            this._context.random().nextBytes(this._extenders[i]);
        }
        if (numExtenders > 0) {
            this._extended = new byte[32];
            this._longToEntry = new byte[this._entryBytes];
            this._longToEntryMask = (1L << (int)((long)this._entryBytes * 8L)) - 1L;
        }
        this._decayEvent = new DecayEvent();
        this._keepDecaying = true;
        SimpleTimer.getInstance().addEvent(this._decayEvent, this._durationMs);
        if (this._log.shouldLog(30)) {
            this._log.warn("New DBF " + name + " m = " + m + " k = " + k + " entryBytes = " + entryBytes + " numExtenders = " + numExtenders + " cycle (s) = " + durationMs / 1000);
        }
        context.statManager().createRateStat("router.decayingBloomFilter." + name + ".size", "Size", "Router", new long[]{Math.max(60000, durationMs)});
        context.statManager().createRateStat("router.decayingBloomFilter." + name + ".dups", "1000000 * Duplicates/Size", "Router", new long[]{Math.max(60000, durationMs)});
        context.statManager().createRateStat("router.decayingBloomFilter." + name + ".log10(falsePos)", "log10 of the false positive rate (must have net.i2p.util.DecayingBloomFilter=DEBUG)", "Router", new long[]{Math.max(60000, durationMs)});
    }

    public long getCurrentDuplicateCount() {
        return this._currentDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInsertedCount() {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this._current.size() + this._previous.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFalsePositiveRate() {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this._current.falsePositives();
        }
    }

    public boolean add(byte[] entry) {
        return this.add(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(byte[] entry, int off, int len) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        if (len != this._entryBytes) {
            throw new IllegalArgumentException("Bad entry [" + len + ", expected " + this._entryBytes + "]");
        }
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this.locked_add(entry, off, len, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long entry) {
        if (this._entryBytes <= 7) {
            entry = (entry ^ this._longToEntryMask) & Integer.MAX_VALUE | entry ^ this._longToEntryMask;
        }
        if (entry < 0L) {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, 0L - entry);
            this._longToEntry[0] = (byte)(this._longToEntry[0] | 0x80);
        } else {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, entry);
        }
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this.locked_add(this._longToEntry, 0, this._longToEntry.length, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnown(long entry) {
        if (this._entryBytes <= 7) {
            entry = (entry ^ this._longToEntryMask) & Integer.MAX_VALUE | entry ^ this._longToEntryMask;
        }
        if (entry < 0L) {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, 0L - entry);
            this._longToEntry[0] = (byte)(this._longToEntry[0] | 0x80);
        } else {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, entry);
        }
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            return this.locked_add(this._longToEntry, 0, this._longToEntry.length, false);
        }
    }

    private boolean locked_add(byte[] entry, int offset, int len, boolean addIfNew) {
        if (this._extended != null) {
            System.arraycopy(entry, offset, this._extended, 0, len);
            for (int i = 0; i < this._extenders.length; ++i) {
                DataHelper.xor(entry, offset, this._extenders[i], 0, this._extended, this._entryBytes * (i + 1), this._entryBytes);
            }
            boolean seen = this._current.locked_member(this._extended);
            boolean bl = seen = seen || this._previous.locked_member(this._extended);
            if (seen) {
                ++this._currentDuplicates;
                return true;
            }
            if (addIfNew) {
                this._current.locked_insert(this._extended);
            }
            return false;
        }
        boolean seen = this._current.locked_member(entry, offset, len);
        boolean bl = seen = seen || this._previous.locked_member(entry, offset, len);
        if (seen) {
            ++this._currentDuplicates;
            return true;
        }
        if (addIfNew) {
            this._current.locked_insert(entry, offset, len);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            this._current.clear();
            this._previous.clear();
            this._currentDuplicates = 0L;
        }
    }

    public void stopDecaying() {
        this._keepDecaying = false;
        SimpleTimer.getInstance().removeEvent(this._decayEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decay() {
        int currentCount = 0;
        long dups = 0L;
        double fpr = 0.0;
        DecayingBloomFilter decayingBloomFilter = this;
        synchronized (decayingBloomFilter) {
            BloomSHA1 tmp = this._previous;
            currentCount = this._current.size();
            if (this._log.shouldLog(10) && currentCount > 0) {
                fpr = this._current.falsePositives();
            }
            this._previous = this._current;
            this._current = tmp;
            this._current.clear();
            dups = this._currentDuplicates;
            this._currentDuplicates = 0L;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Decaying the filter " + this._name + " after inserting " + currentCount + " elements and " + dups + " false positives with FPR = " + fpr);
        }
        this._context.statManager().addRateData("router.decayingBloomFilter." + this._name + ".size", currentCount, 0L);
        if (currentCount > 0) {
            this._context.statManager().addRateData("router.decayingBloomFilter." + this._name + ".dups", 1000000L * dups / (long)currentCount, 0L);
        }
        if (fpr > 0.0) {
            long exponent = (long)Math.log10(fpr);
            this._context.statManager().addRateData("router.decayingBloomFilter." + this._name + ".log10(falsePos)", exponent, 0L);
        }
    }

    public static void main(String[] args) {
        int kbps = 256;
        int iterations = 10;
        DecayingBloomFilter.testByLong(kbps, iterations);
        DecayingBloomFilter.testByBytes(kbps, iterations);
    }

    private static void testByLong(int kbps, int numRuns) {
        int messages = 600 * kbps;
        Random r = new Random();
        DecayingBloomFilter filter = new DecayingBloomFilter(I2PAppContext.getGlobalContext(), 600000, 8);
        int falsePositives = 0;
        long totalTime = 0L;
        double fpr = 0.0;
        for (int j = 0; j < numRuns; ++j) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < messages; ++i) {
                if (!filter.add(r.nextLong())) continue;
                System.out.println("False positive " + ++falsePositives + " (testByLong j=" + j + " i=" + i + ")");
            }
            totalTime += System.currentTimeMillis() - start;
            fpr = filter.getFalsePositiveRate();
            filter.clear();
        }
        filter.stopDecaying();
        System.out.println("False postive rate should be " + fpr);
        System.out.println("After " + numRuns + " runs pushing " + messages + " entries in " + DataHelper.formatDuration(totalTime / (long)numRuns) + " per run, there were " + falsePositives + " false positives");
    }

    private static void testByBytes(int kbps, int numRuns) {
        byte[][] iv = new byte[600 * kbps][16];
        Random r = new Random();
        for (int i = 0; i < iv.length; ++i) {
            r.nextBytes(iv[i]);
        }
        DecayingBloomFilter filter = new DecayingBloomFilter(I2PAppContext.getGlobalContext(), 600000, 16);
        int falsePositives = 0;
        long totalTime = 0L;
        double fpr = 0.0;
        for (int j = 0; j < numRuns; ++j) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < iv.length; ++i) {
                if (!filter.add(iv[i])) continue;
                System.out.println("False positive " + ++falsePositives + " (testByBytes j=" + j + " i=" + i + ")");
            }
            totalTime += System.currentTimeMillis() - start;
            fpr = filter.getFalsePositiveRate();
            filter.clear();
        }
        filter.stopDecaying();
        System.out.println("False postive rate should be " + fpr);
        System.out.println("After " + numRuns + " runs pushing " + iv.length + " entries in " + DataHelper.formatDuration(totalTime / (long)numRuns) + " per run, there were " + falsePositives + " false positives");
    }

    private class DecayEvent
    implements SimpleTimer.TimedEvent {
        private DecayEvent() {
        }

        public void timeReached() {
            if (DecayingBloomFilter.this._keepDecaying) {
                DecayingBloomFilter.this.decay();
                SimpleTimer.getInstance().addEvent(this, DecayingBloomFilter.this._durationMs);
            }
        }
    }
}

